/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class ASRectangle
extends ASObject {
    private double left;
    private double bottom;
    private double right;
    private double top;

    public ASRectangle(ASCoordinate ll, ASCoordinate ur) {
        this.left = ll.x();
        this.bottom = ll.y();
        this.right = ur.x();
        this.top = ur.y();
    }

    public ASRectangle(double left, double bottom, double right, double top) {
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
    }

    public ASRectangle(double[] coords) throws PDFInvalidParameterException {
        if (coords.length != 4) {
            throw new PDFInvalidParameterException("attempt to construct ASRectangle with invalid parameters");
        }
        this.left = coords[0];
        this.bottom = coords[1];
        this.right = coords[2];
        this.top = coords[3];
    }

    public ASRectangle(ASRectangle rect) {
        this.left = rect.left;
        this.bottom = rect.bottom;
        this.right = rect.right;
        this.top = rect.top;
    }

    public String toString() {
        return "[ " + this.left + " " + this.bottom + " " + this.right + " " + this.top + " ]";
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(this.toString().getBytes());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public double[] getValues() {
        double[] vals = new double[]{this.left, this.bottom, this.right, this.top};
        return vals;
    }

    public ASCoordinate ll() {
        return new ASCoordinate(this.left, this.bottom);
    }

    public ASCoordinate lr() {
        return new ASCoordinate(this.right, this.bottom);
    }

    public ASCoordinate ur() {
        return new ASCoordinate(this.right, this.top);
    }

    public ASCoordinate ul() {
        return new ASCoordinate(this.left, this.top);
    }

    public double left() {
        return this.left;
    }

    public double bottom() {
        return this.bottom;
    }

    public double right() {
        return this.right;
    }

    public double top() {
        return this.top;
    }

    public double width() {
        return Math.abs(this.right - this.left);
    }

    public double height() {
        return Math.abs(this.top - this.bottom);
    }

    public ASRectangle transform(ASMatrix ctm) {
        ASCoordinate ll = this.ll().transform(ctm);
        ASCoordinate ur = this.ur().transform(ctm);
        return new ASRectangle(ll, ur);
    }

    public boolean hasNonZeroDimensions() {
        if (this.left == 0.0 && this.bottom == 0.0 && this.right == 0.0 && this.top == 0.0) {
            return false;
        }
        return this.height() != 0.0 && this.width() != 0.0;
    }

    public boolean hasNonZeroDimensions(double epsilon) {
        if (Math.abs(this.left) < epsilon && Math.abs(this.bottom) < epsilon && Math.abs(this.right) < epsilon && Math.abs(this.top) < epsilon) {
            return false;
        }
        return !(this.height() < epsilon) && !(this.width() < epsilon);
    }

    public boolean contains(ASRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isRectContained = false;
        Rectangle2D.Double currentRectangle = new Rectangle2D.Double(this.ll().x(), this.ll().y(), this.ur().x() - this.ll().x(), this.ur().y() - this.ll().y());
        isRectContained = currentRectangle.contains(rect.ll().x(), rect.ll().y(), rect.ur().x() - rect.ll().x(), rect.ur().y() - rect.ll().y());
        return isRectContained;
    }

    public ASRectangle normalized() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] newVals = new double[]{Math.min(this.left(), this.right()), Math.min(this.bottom(), this.top()), Math.max(this.left(), this.right()), Math.max(this.bottom(), this.top())};
        return new ASRectangle(newVals[0], newVals[1], newVals[2], newVals[3]);
    }
}

