/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.util;

import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.nio.ByteBuffer;

public class StringOps {
    private StringOps() {
    }

    public static byte[] convertFromHex(String hexStr) {
        byte[] converted = new byte[hexStr.length() / 2];
        int numBytes = 0;
        int charInd = 0;
        int b1 = -1;
        int b2 = -1;
        boolean first = true;
        while (charInd < hexStr.length()) {
            if (first) {
                if ((b1 = Character.digit(hexStr.charAt(charInd++), 16)) == -1) continue;
                first = false;
                continue;
            }
            if ((b2 = Character.digit(hexStr.charAt(charInd++), 16)) == -1) continue;
            first = true;
            converted[numBytes++] = (byte)(b1 << 4 | b2);
        }
        return numBytes > 0 ? ByteBuffer.wrap(converted, 0, numBytes).array() : null;
    }

    public static boolean isASCII(String str) {
        for (int strInd = 0; strInd < str.length(); ++strInd) {
            char curChar = str.charAt(strInd);
            if (curChar <= '\u007f' && (curChar >= ' ' || ByteOps.isWhitespace(curChar))) continue;
            return false;
        }
        return true;
    }

    public static byte[] toByteArray(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }
}

