/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.util;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;

public final class Utility {
    private Utility() {
    }

    public static boolean nameInArray(ASName key, ASName[] keys) {
        int keyInd = 0;
        while (keyInd < keys.length) {
            if (!key.equals(keys[keyInd++])) continue;
            return true;
        }
        return false;
    }

    public static int[] ComputeKMPNextArray(byte[] key) {
        int pmax = key.length;
        int[] next = new int[pmax];
        for (int k = 0; k < pmax; ++k) {
            next[k] = -2;
        }
        int nextTest = -1;
        int i = 0;
        next[0] = -1;
        do {
            if (nextTest == -1 || key[nextTest] == key[i]) {
                ++nextTest;
                if (++i >= pmax) continue;
                if (key[nextTest] == key[i]) {
                    next[i] = next[nextTest];
                    continue;
                }
                next[i] = nextTest;
                continue;
            }
            nextTest = next[nextTest];
        } while (i < pmax);
        return next;
    }

    public static int KMPFindFirst(byte[] key, int[] next, byte[] target) {
        int keySize = key.length;
        int targetSize = target.length;
        int keyIndex = 0;
        int targetIndex = 0;
        while (targetIndex < targetSize) {
            if (keyIndex == -1 || key[keyIndex] == target[targetIndex]) {
                if (++keyIndex == keySize) {
                    return targetIndex + 1 - keySize;
                }
                ++targetIndex;
                continue;
            }
            keyIndex = next[keyIndex];
        }
        return -1;
    }

    public static long KMPFindFirst(byte[] key, int[] next, InputByteStream targetstm) throws IOException {
        int keySize = key.length;
        int keyIndex = 0;
        byte targetbyte = (byte)targetstm.read();
        while (true) {
            if (keyIndex == -1 || key[keyIndex] == targetbyte) {
                if (++keyIndex == keySize) {
                    return targetstm.getPosition() - (long)keySize;
                }
                if (targetstm.eof()) {
                    return -1L;
                }
                targetbyte = (byte)targetstm.read();
                continue;
            }
            keyIndex = next[keyIndex];
        }
    }
}

