/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xmp;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.XMPVersionInfo;
import com.adobe.internal.xmp.impl.XMPMetaImpl;
import com.adobe.internal.xmp.impl.XMPMetaParser;
import com.adobe.internal.xmp.impl.XMPSchemaRegistryImpl;
import com.adobe.internal.xmp.impl.XMPSerializerHelper;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XMPMetaFactory {
    private static XMPSchemaRegistry schema = new XMPSchemaRegistryImpl();
    private static XMPVersionInfo versionInfo = null;

    private XMPMetaFactory() {
    }

    public static XMPSchemaRegistry getSchemaRegistry() {
        return schema;
    }

    public static XMPMeta create() {
        return new XMPMetaImpl();
    }

    public static XMPMeta parse(InputStream in, long timeOut) throws XMPException {
        return XMPMetaFactory.parse(in, null, timeOut);
    }

    public static XMPMeta parse(InputStream in, ParseOptions options, long timeOut) throws XMPException {
        if (timeOut < 0L) {
            throw new XMPException("TimeOut cannot be negative", 4);
        }
        return XMPMetaParser.parse((Object)in, (ParseOptions)options, (long)timeOut);
    }

    public static XMPMeta parse(InputStream in) throws XMPException {
        return XMPMetaFactory.parse(in, null);
    }

    public static XMPMeta parse(InputStream in, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse((Object)in, (ParseOptions)options, (long)0L);
    }

    public static XMPMeta parseFromString(String packet) throws XMPException {
        return XMPMetaFactory.parseFromString(packet, null);
    }

    public static XMPMeta parseFromString(String packet, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse((Object)packet, (ParseOptions)options, (long)0L);
    }

    public static XMPMeta parseFromBuffer(byte[] buffer) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(buffer, null);
    }

    public static XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse((Object)buffer, (ParseOptions)options, (long)0L);
    }

    public static void serialize(XMPMeta xmp, OutputStream out) throws XMPException {
        XMPMetaFactory.serialize(xmp, out, null);
    }

    public static void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        XMPSerializerHelper.serialize((XMPMetaImpl)((XMPMetaImpl)xmp), (OutputStream)out, (SerializeOptions)options);
    }

    public static byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        return XMPSerializerHelper.serializeToBuffer((XMPMetaImpl)((XMPMetaImpl)xmp), (SerializeOptions)options);
    }

    public static String serializeToString(XMPMeta xmp, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        return XMPSerializerHelper.serializeToString((XMPMetaImpl)((XMPMetaImpl)xmp), (SerializeOptions)options);
    }

    private static void assertImplementation(XMPMeta xmp) {
        if (!(xmp instanceof XMPMetaImpl)) {
            throw new UnsupportedOperationException("The serializing service works onlywith the XMPMeta implementation of this library");
        }
    }

    public static void reset() {
        schema = new XMPSchemaRegistryImpl();
    }

    public static synchronized XMPVersionInfo getVersionInfo() {
        if (versionInfo == null) {
            String bundleVersion = "Test.SNAPSHOT";
            int major = 5;
            int minor = 0;
            int micro = 0;
            try {
                Enumeration<URL> resources = XMPMetaFactory.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    Attributes attrs = manifest.getMainAttributes();
                    if (!"com.adobe.xmp.xmpcore".equals(attrs.getValue("Bundle-SymbolicName")) || attrs.getValue("Bundle-Version") == null) continue;
                    bundleVersion = attrs.getValue("Bundle-Version");
                    Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
                    Matcher matcher = pattern.matcher(bundleVersion);
                    if (!matcher.find()) continue;
                    major = Integer.parseInt(matcher.group(1));
                    minor = Integer.parseInt(matcher.group(2));
                    micro = Integer.parseInt(matcher.group(3));
                    break;
                }
            }
            catch (IOException resources) {
                // empty catch block
            }
            final String message = "Adobe XMP Core " + bundleVersion;
            final int majorVersion = major;
            final int minorVersion = minor;
            final int microVersion = micro;
            versionInfo = new XMPVersionInfo(){

                @Override
                public int getMajor() {
                    return majorVersion;
                }

                @Override
                public int getMinor() {
                    return minorVersion;
                }

                @Override
                public int getMicro() {
                    return microVersion;
                }

                @Override
                public boolean isDebug() {
                    return true;
                }

                @Override
                public int getBuild() {
                    return 0;
                }

                @Override
                public String getMessage() {
                    return message;
                }

                public String toString() {
                    return message;
                }
            };
        }
        return versionInfo;
    }
}

