/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren.builder;

import com.adobe.reef.siren.Action;
import com.adobe.reef.siren.Field;
import com.adobe.reef.siren.builder.Builder;
import com.adobe.reef.siren.builder.BuilderException;
import com.adobe.reef.siren.builder.BuilderValidationException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBuilder
extends Builder<Action> {
    private String name;
    private String[] clazz;
    private Action.Method method;
    private String href;
    private String title;
    private String type;
    private List<Field> fields = new LinkedList<Field>();

    public ActionBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ActionBuilder setClass(String[] clazz) {
        this.clazz = clazz;
        return this;
    }

    public ActionBuilder setMethod(Action.Method method) {
        this.method = method;
        return this;
    }

    public ActionBuilder setHref(String href) {
        this.href = href;
        return this;
    }

    public ActionBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ActionBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public ActionBuilder setFields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public ActionBuilder addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public ActionBuilder clear() {
        this.clazz = null;
        this.method = null;
        this.type = null;
        this.title = null;
        this.fields.clear();
        return this;
    }

    @Override
    protected Action doBuild() throws BuilderException {
        try {
            Action action = new Action(this.name, this.href);
            action.setClazz(this.clazz);
            action.setMethod(this.method);
            action.setType(this.type);
            action.setTitle(this.title);
            action.setFields(this.fields);
            return action;
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    @Override
    protected void validate(Action action) throws BuilderValidationException {
        if (action.getName() == null || action.getName().isEmpty() || action.getHref() == null || action.getHref().isEmpty()) {
            throw new BuilderValidationException("name and href attribute cannot be null or empty.");
        }
    }
}

