/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.nativecomm;

import com.adobe.versioncue.internal.nativecomm.IMonitor;
import com.adobe.versioncue.internal.nativecomm.NativeService;
import com.adobe.versioncue.internal.nativecomm.ServiceBuilder;
import com.adobe.versioncue.internal.nativecomm.ServiceConfig;
import com.adobe.versioncue.internal.nativecomm.io.TCPConnection;
import com.adobe.versioncue.nativecomm.INativeService;
import com.adobe.versioncue.nativecomm.IServiceBuilder;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.io.IConnection;
import com.adobe.versioncue.nativecomm.io.IConnectionFactory;
import java.io.File;

public final class NativeComm {
    private static ServiceConfig defaults;

    public static IServiceBuilder serviceBuilder(String id) {
        ServiceConfig cfg = defaults.clone().id(id);
        return new ServiceBuilder(cfg);
    }

    public static INativeService service(String id, final int port) {
        final ServiceConfig cfg = new ServiceConfig(id);
        cfg.maxConnections(2);
        IConnectionFactory factory = new IConnectionFactory(){

            @Override
            public IConnection[] connect(INativeService service) throws NativeCommException {
                TCPConnection con = new TCPConnection(cfg, port);
                return new IConnection[]{con};
            }
        };
        return new NativeService(cfg, factory, IMonitor.DUMMY);
    }

    public static String getDefaultCommand() {
        return defaults.command();
    }

    public static File getDefaultTmpDir() {
        return defaults.tmpDir();
    }

    public static File getDefaultLogDir() {
        return defaults.logDir();
    }

    public static int getDefaultMaxConnections() {
        return defaults.maxConnections();
    }

    public static int getDefaultMaxRequests() {
        return defaults.maxRequests();
    }

    public static int getDefaultRequestTimeout() {
        return defaults.requestTimeout();
    }

    public static int getDefaultRequestRetries() {
        return defaults.requestRetries();
    }

    public static int getDefaultLaunchTimeout() {
        return defaults.launchTimeout();
    }

    public static void setDefaultCommand(String command) {
        defaults.command(command);
    }

    public static void setDefaultTmpDir(File tmpDir) {
        defaults.tmpDir(tmpDir);
    }

    public static void setDefaultLogDir(File logDir) {
        defaults.logDir(logDir);
    }

    public static void setDefaultMaxConnections(int maxConnections) {
        defaults.maxConnections(maxConnections);
    }

    public static void setDefaultMaxRequests(int maxRequests) {
        defaults.maxRequests(maxRequests);
    }

    public static void setDefaultRequestTimeout(int timeout) {
        defaults.requestTimeout(timeout);
    }

    public static void setDefaultRequestRetries(int retries) {
        defaults.requestRetries(retries);
    }

    public static void setDefaultLaunchTimeout(int timeout) {
        defaults.launchTimeout(timeout);
    }

    private NativeComm() {
    }

    static {
        String defaultCommand;
        defaults = new ServiceConfig("defaults");
        switch (OS.current) {
            case win32: {
                defaultCommand = "VCNativeHelper.exe";
                break;
            }
            default: {
                defaultCommand = "VCNativeHelper";
            }
        }
        defaults.command(defaultCommand);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        defaults.tmpDir(tmpDir);
        defaults.logDir(new File("logs").getAbsoluteFile());
    }

    public static enum OS {
        win32,
        linux,
        macosx,
        solaris,
        unknown;

        public static final OS current;

        public static boolean isWin32() {
            return current == win32;
        }

        public static boolean isLinux() {
            return current == linux;
        }

        public static boolean isMacOSX() {
            return current == macosx;
        }

        public static boolean isSolaris() {
            return current == solaris;
        }

        static {
            String os = System.getProperty("os.name").toLowerCase();
            current = os.startsWith("mac os x") ? macosx : (os.startsWith("win") ? win32 : (os.startsWith("linux") ? linux : (os.startsWith("sunos") ? solaris : unknown)));
        }
    }
}

