/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DeltaScript;
import com.adobe.xfa.Element;
import com.adobe.xfa.Obj;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public final class Delta
extends Obj {
    final boolean mbRecursiveRestore;
    boolean mbRestored;
    final Element mDeltaParent;
    final Object mDeltaValue;
    final Element mParent;
    final Object mValue;
    String msTarget;

    public Delta(Element parent, Element deltaParent, Object currentValue, Object savedValue, String sTarget) {
        this.mValue = currentValue;
        this.mDeltaValue = savedValue;
        this.mParent = parent;
        this.mDeltaParent = deltaParent;
        this.msTarget = sTarget;
        this.mbRecursiveRestore = false;
    }

    public Delta(Element parent, Element deltaParent, String sSOM) {
        Obj obj;
        this.mbRecursiveRestore = true;
        SOMParser parser = new SOMParser(null);
        ArrayList<SOMParser.SomResultInfo> results = new ArrayList<SOMParser.SomResultInfo>();
        Element resolvedParent = null;
        Object value = null;
        if (parser.resolve(parent, sSOM, results) && results.size() == 1) {
            SOMParser.SomResultInfo result = (SOMParser.SomResultInfo)results.get(0);
            Arg arg = result.value;
            obj = result.object;
            if (obj instanceof Element) {
                resolvedParent = (Element)obj;
                this.msTarget = result.propertyName;
                if (result.occurrence != 0) {
                    String sNum = Integer.toString(result.occurrence);
                    this.msTarget = this.msTarget + '[';
                    this.msTarget = this.msTarget + sNum;
                    this.msTarget = this.msTarget + ']';
                }
            }
            if (arg.getArgType() == 7) {
                Obj objValue = arg.getObject();
                if (objValue instanceof Element) {
                    value = objValue;
                }
            } else if (arg.getArgType() != 8) {
                StringAttr attrValue = new StringAttr(null, arg.getString());
                value = attrValue;
            }
        }
        this.mParent = resolvedParent;
        this.mValue = value;
        results.clear();
        Object deltaValue = null;
        if (deltaParent != null && parent.isSameClass(deltaParent) && parser.resolve(deltaParent, sSOM, results) && results.size() == 1) {
            Arg arg;
            SOMParser.SomResultInfo result = (SOMParser.SomResultInfo)results.get(0);
            obj = result.object;
            if (obj instanceof Element) {
                deltaParent = (Element)obj;
            }
            if ((arg = result.value).getArgType() == 7) {
                Obj objValue = arg.getObject();
                if (objValue instanceof Element) {
                    deltaValue = objValue;
                }
            } else if (arg.getArgType() != 8) {
                StringAttr attrValue = new StringAttr(null, arg.getString());
                deltaValue = attrValue;
            }
        }
        this.mDeltaParent = deltaParent;
        this.mDeltaValue = deltaValue;
    }

    @Override
    public String getClassAtom() {
        return "delta";
    }

    @Override
    public String getClassName() {
        return "delta";
    }

    String getCurrentValue() {
        return this.propToString(this.mValue);
    }

    Element getParent() {
        return this.mParent;
    }

    String getSavedValue() {
        if (this.mDeltaValue == null) {
            return this.propToString(this.mValue);
        }
        return this.propToString(this.mDeltaValue);
    }

    @Override
    public ScriptTable getScriptTable() {
        return DeltaScript.getScriptTable();
    }

    String getTarget() {
        Object oDeltaValue = this.mValue;
        if (StringUtils.isEmpty(this.msTarget) && oDeltaValue instanceof Element) {
            Element oNode = (Element)this.mValue;
            this.msTarget = oNode.getSOMExpression(this.mParent, false);
        }
        return this.msTarget;
    }

    String propToString(Object property) {
        if (property == null) {
            return "";
        }
        if (property instanceof Attribute) {
            Attribute attr = (Attribute)property;
            return attr.toString();
        }
        if (property instanceof Element) {
            ByteArrayOutputStream outFile = new ByteArrayOutputStream();
            Element node = (Element)property;
            node.saveXML(outFile, null);
            return outFile.toString();
        }
        if (property instanceof TextNode) {
            TextNode oNode = (TextNode)property;
            AppModel appModel = oNode.getModel().getAppModel();
            if (appModel != null && !appModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
                return oNode.getText();
            }
            return oNode.getText();
        }
        return "";
    }

    public void restore() {
        if (this.mbRestored) {
            return;
        }
        if (this.mDeltaValue == null) {
            return;
        }
        Object deltaValue = this.mDeltaValue;
        if (deltaValue instanceof Attribute && this.mParent != null) {
            String aAttrName = this.msTarget.intern();
            int eTag = XFA.getAttributeTag(aAttrName);
            if (eTag != -1) {
                Attribute attr = (Attribute)this.mDeltaValue;
                this.mParent.setAttribute(attr, eTag);
                if (this.mDeltaParent != null && this.mDeltaParent != this.mParent) {
                    this.mDeltaParent.setAttribute(null, eTag);
                }
            }
        } else if (deltaValue instanceof Element && this.mDeltaValue != this.mValue) {
            Element deltaNode = (Element)this.mDeltaValue;
            Element node = (Element)this.mValue;
            if (node == null) {
                if (deltaNode != null) {
                    deltaNode.remove();
                    this.mParent.appendChild(deltaNode);
                }
            } else if (this.mbRecursiveRestore) {
                XFAList list = new XFAList();
                node.getDeltas(deltaNode, list);
                int nLen = list.length();
                for (int i = 0; i < nLen; ++i) {
                    Delta delta = (Delta)list.item(i);
                    delta.restore();
                }
            } else {
                node.restoreDelta(deltaNode);
            }
        } else if (deltaValue instanceof TextNode && this.mDeltaValue != this.mValue) {
            TextNode deltaNode = (TextNode)this.mDeltaValue;
            TextNode node = (TextNode)this.mValue;
            if (node == null) {
                if (deltaNode != null) {
                    deltaNode.remove();
                }
            } else {
                node.restoreDelta(deltaNode);
            }
        }
        this.mbRestored = true;
    }
}

