/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumType;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.StringUtils;

public final class EnumValue
extends Attribute {
    private final EnumAttr mValue;
    private final int meAttr;
    private static final int[][] mAmbiguousTypes = new int[][]{{402, -2145648640}, {402, -2144796672}, {402, -2144665600}, {402, -2140930048}, {402, -2141716480}, {387, -2140995584}, {387, -2145124352}, {593, -2144862208}, {593, 0x40040000}, {401, -2145517568}, {401, -2144927744}, {377, -2142502912}, {377, -2138112000}, {620, -2144600064}, {620, -2140209152}, {574, 0x500000}, {574, -2142175232}, {574, -2142109696}, {574, -2142044160}, {574, 0x900000}, {574, -2141978624}};
    private static final int[][] mConfigTypes = new int[][]{{7, 0x40040000}, {11, 0x40040000}, {12, 0x40040000}, {13, 0x40040000}, {23, 0x40030000}, {370, 0x40040000}, {54, 0x40040000}, {53, 0x40040000}, {59, 1082261504}, {65, 0x40040000}, {96, 0x40410000}, {101, 0x40040000}, {104, 1081409536}, {105, 0x40660000}, {112, 0x40040000}, {111, 0x40040000}, {488, 0x40040000}, {116, 0x400A0000}, {114, 0x40040000}, {136, 0x40040000}, {145, 0x40040000}, {152, 1075314688}, {165, 0x40040000}, {157, 0x40470000}, {168, 1081737216}, {379, 1079771136}, {174, 0x40040000}, {383, 0x40040000}, {386, 1075904512}, {219, 1082327040}, {226, 1081671680}, {227, 1082589184}, {243, 0x40040000}, {391, 1076494336}, {246, 0x40040000}, {268, 1080557568}, {273, 1080754176}, {274, 1076690944}, {279, 1076822016}, {302, 1077346304}, {307, 0x40040000}, {310, 1080688640}, {309, 0x40040000}, {399, 0x40200000}, {401, -2144927744}, {401, -2145517568}, {402, 0x4F0000}, {404, 0x40040000}, {345, 1077870592}, {338, 0x40880000}, {249, 1082785792}, {241, 0x40040000}};
    private static final EnumValue[][] mAllEnumAttrs = new EnumValue[357][];
    private static final EnumValue[][] mAmbiguousAttrs = new EnumValue[mAmbiguousTypes.length][];
    private static final EnumValue[][] mConfigAttrs = new EnumValue[mConfigTypes.length][];

    private EnumValue(EnumType enumType, int eAttrTag, String NS, String localName, String qName, String value) {
        super(NS, localName, qName, value, false);
        this.mValue = EnumAttr.getEnum(enumType, this.getAttrValue());
        this.meAttr = eAttrTag;
    }

    public EnumAttr getAttr() {
        return this.mValue;
    }

    public int getInt() {
        return this.mValue.getInt();
    }

    public EnumType getType() {
        return this.mValue.getType();
    }

    @Override
    public Attribute newAttribute(String value) {
        return this.newAttribute(null, null, null, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value) {
        return this.newAttribute(NS, localName, qName, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        if (internSymbols) {
            value = value.intern();
        }
        return EnumValue.getEnum(this.mValue.getType(), this.meAttr, value);
    }

    public int getAttrTag() {
        return this.meAttr;
    }

    private static EnumValue getEnum(EnumType enumType, int eAttrTag, String value) {
        EnumAttr a = EnumAttr.getEnum(enumType, value);
        return EnumValue.getEnum(eAttrTag, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static EnumValue getEnum(int eAttrTag, EnumAttr value) {
        int offset;
        EnumValue v;
        EnumValue[][] enumValueArray;
        EnumValue[] vals;
        int index;
        EnumType enumType;
        block25: {
            int eType;
            block26: {
                block24: {
                    block23: {
                        enumType = value.getType();
                        eType = enumType.getInt();
                        index = -1;
                        vals = null;
                        if (!enumType.usedAmbiguously()) break block23;
                        break block24;
                    }
                    if (!enumType.usedElementarily()) break block25;
                    break block26;
                }
                for (index = 0; index < mAmbiguousTypes.length && (mAmbiguousTypes[index][0] != eAttrTag || mAmbiguousTypes[index][1] != eType); ++index) {
                }
                break block25;
            }
            for (index = 0; index < mConfigTypes.length && (mConfigTypes[index][0] != eAttrTag || mConfigTypes[index][1] != eType); ++index) {
            }
            if (index == mConfigTypes.length) {
                index = -1;
            }
        }
        if (index == -1) {
            assert (eAttrTag > 363);
            vals = mAllEnumAttrs[eAttrTag - 363];
            if (vals == null) {
                enumValueArray = mAllEnumAttrs;
                // MONITORENTER : mAllEnumAttrs
                vals = mAllEnumAttrs[eAttrTag - 363];
                if (vals == null) {
                    vals = new EnumValue[value.getValues().length];
                    EnumValue.mAllEnumAttrs[eAttrTag - 363] = vals;
                }
                // MONITOREXIT : enumValueArray
            }
        } else if (enumType.usedAmbiguously()) {
            vals = mAmbiguousAttrs[index];
            if (vals == null) {
                enumValueArray = mAmbiguousAttrs;
                // MONITORENTER : mAmbiguousAttrs
                vals = mAmbiguousAttrs[index];
                if (vals == null) {
                    vals = new EnumValue[value.getValues().length];
                    EnumValue.mAmbiguousAttrs[index] = vals;
                }
                // MONITOREXIT : enumValueArray
            }
        } else {
            vals = mConfigAttrs[index];
            if (vals == null) {
                enumValueArray = mConfigAttrs;
                // MONITORENTER : mConfigAttrs
                vals = mConfigAttrs[index];
                if (vals == null) {
                    vals = new EnumValue[value.getValues().length];
                    EnumValue.mConfigAttrs[index] = vals;
                }
                // MONITOREXIT : enumValueArray
            }
        }
        if ((v = vals[offset = value.getInt() & 0xFFFF]) != null) return v;
        EnumValue[] enumValueArray2 = vals;
        // MONITORENTER : vals
        v = vals[offset];
        if (v == null) {
            String name = XFA.getString(eAttrTag);
            vals[offset] = v = new EnumValue(enumType, eAttrTag, null, name, name, value.toString());
        }
        // MONITOREXIT : enumValueArray2
        return v;
    }

    public static EnumValue getEnum(int eAttrTag, int value) {
        return EnumValue.getEnum(eAttrTag, EnumAttr.getEnum(value));
    }
}

