/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.ChildRelnInfo;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.Schema;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationKey;
import com.adobe.xfa.configuration.ConfigurationModelFactory;
import com.adobe.xfa.configuration.ConfigurationSchema;
import com.adobe.xfa.configuration.ConfigurationUri;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public final class ConfigurationModel
extends Model {
    private static final ConfigurationSchema gConfigurationSchema = new ConfigurationSchema();

    @Override
    public Node createNode(int eTag, Element parent, String aName, String aNS, boolean bDoVersionCheck) {
        assert (aName != null);
        assert (aNS != null);
        if (eTag == 0) {
            Element grandParent;
            Element oRet = this.getSchema().getInstance(eTag, this, parent, null, bDoVersionCheck);
            if (parent instanceof ConfigurationValue && (grandParent = parent.getXFAParent()) != null) {
                Attribute sValue = this.getSchema().defaultAttribute(parent.getClassTag(), grandParent.getClassTag());
                oRet.setAttribute(sValue, 405);
            }
            return oRet;
        }
        if (eTag == 57) {
            return new ConfigurationKey(parent, null);
        }
        if (eTag == 58) {
            return new ConfigurationValue(parent, null);
        }
        Element oRet = this.getSchema().getInstance(eTag, this, parent, null, bDoVersionCheck);
        if (oRet.isValidAttr(574, false, null)) {
            oRet.setName(aName);
        }
        return oRet;
    }

    @Override
    public String getHeadNS() {
        return ConfigurationModel.configurationNS();
    }

    protected static Schema getModelSchema() {
        return gConfigurationSchema;
    }

    public static ConfigurationModel getConfigurationModel(AppModel appModel, boolean bCreateIfNotFound) {
        ConfigurationModel configModel = (ConfigurationModel)Model.getNamedModel(appModel, "config");
        if (bCreateIfNotFound && configModel == null) {
            ConfigurationModelFactory factory = new ConfigurationModelFactory();
            configModel = (ConfigurationModel)factory.createDOM((Element)appModel.getXmlPeer());
            configModel.setDocument(appModel.getDocument());
            appModel.notifyPeers(4, "config", configModel);
        }
        return configModel;
    }

    public static String configurationNS() {
        return "http://www.xfa.org/schema/xci/3.0/";
    }

    public ConfigurationModel(Element parent, Node prevSibling) {
        super(parent, prevSibling, ConfigurationModel.configurationNS(), "config", "config", "$config", 56, "config", ConfigurationModel.getModelSchema());
    }

    @Override
    public String getBaseNS() {
        return "http://www.xfa.org/schema/xci/";
    }

    @Override
    protected void postLoad() {
        this.postLoadFixUp(this);
        ConfigurationModel oPrevConfigurationModel = null;
        AppModel appModel = this.getAppModel();
        if (appModel != null) {
            for (Node child = appModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (child == this || !(child instanceof ConfigurationModel)) continue;
                oPrevConfigurationModel = (ConfigurationModel)child;
                break;
            }
        }
        if (oPrevConfigurationModel != null) {
            oPrevConfigurationModel.mergeModel(this);
            appModel.removeChild(this);
        }
    }

    @Override
    public boolean isVersionCompatible(int nVersion, int nTargetVersion) {
        if (nVersion <= 25) {
            nVersion = 25;
        }
        if (nTargetVersion <= 25) {
            nTargetVersion = 25;
        }
        return super.isVersionCompatible(nVersion, nTargetVersion);
    }

    @Override
    public String getNS() {
        int nVersion = this.getCurrentVersion();
        AppModel appModel = this.getAppModel();
        if (appModel != null) {
            for (Node child = appModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof TemplateModel)) continue;
                nVersion = ((TemplateModel)child).getCurrentVersion();
                break;
            }
        }
        if (nVersion > 0) {
            if (nVersion > 30) {
                nVersion = 30;
            } else if (nVersion > 25 && nVersion < 28) {
                nVersion = 26;
            } else if (nVersion <= 25) {
                nVersion = 10;
            }
            double dVersion = (double)nVersion / 10.0;
            String sNSBuf = this.getBaseNS() + Numeric.doubleToString(dVersion, 1, false) + '/';
            return sNSBuf.intern();
        }
        return super.getNS();
    }

    public Attribute getConfigValue(String sSOM, BooleanHolder isDefault) {
        int nFoundAt;
        Node oNode;
        isDefault.value = false;
        Node oContextNode = this.getContext();
        assert (oContextNode != null);
        ArrayList<SOMParser.SomResultInfo> oLHSResult = new ArrayList<SOMParser.SomResultInfo>();
        SOMParser oParser = new SOMParser(null);
        oParser.resolve(oContextNode, sSOM, oLHSResult);
        if (oLHSResult.size() > 1) {
            throw new ExFull(ResId.SOMTypeException);
        }
        if (oLHSResult.size() == 1) {
            SOMParser.SomResultInfo oSRI = (SOMParser.SomResultInfo)oLHSResult.get(0);
            if (!StringUtils.isEmpty(oSRI.propertyName)) {
                isDefault.value = true;
                return new StringAttr(oSRI.propertyName, oSRI.value.getString());
            }
            if (!(oSRI.object instanceof ConfigurationValue)) {
                throw new ExFull(new MsgFormat(ResId.InvalidCommandlineOption, sSOM));
            }
            ConfigurationValue oConfigValue = (ConfigurationValue)oSRI.object;
            Attribute oValue = oConfigValue.getValue(isDefault);
            isDefault.value = !isDefault.value;
            return oValue;
        }
        Node oParent = oContextNode;
        String sChild = null;
        int nOffset = -1;
        String sTag = sSOM;
        while ((nOffset = sTag.indexOf(46)) >= 0 && (oNode = oParent.resolveNode(sChild = sTag.substring(0, nOffset))) != null) {
            oParent = oNode;
            sTag = sTag.substring(nOffset + 1);
        }
        if (!(oParent instanceof ConfigurationKey)) {
            return new StringAttr("", "");
        }
        Schema oSchema = this.getSchema();
        if (oParent.isSameClass("configurationKey")) {
            int eTag = XFA.getTag(sChild.intern());
            return oSchema.defaultAttribute(eTag, 58);
        }
        int eParent = oParent.getClassTag();
        while ((nOffset = sTag.indexOf(46)) >= 0) {
            sChild = sTag.substring(0, nOffset);
            nFoundAt = sChild.indexOf(91);
            if (nFoundAt >= 0) {
                sChild = sChild.substring(0, nFoundAt);
            }
            ChildRelnInfo oReln = null;
            int eChild = XFA.getTag(sChild.intern());
            if (eChild >= 0) {
                oReln = oSchema.getNodeSchema(eParent).getChildRelnInfo(eChild);
            }
            if (oReln == null) {
                oReln = oSchema.getNodeSchema(eParent).getChildRelnInfo(57);
                if (oReln == null) {
                    return new StringAttr("", "");
                }
                eParent = 57;
                break;
            }
            eParent = eChild;
            sTag = sTag.substring(nOffset + 1);
        }
        if ((nFoundAt = sTag.indexOf(91)) >= 0) {
            sTag = sTag.substring(0, nFoundAt);
        }
        int eTag = XFA.getTag(sTag.intern());
        ChildRelnInfo oReln = null;
        if (eTag >= 0) {
            oReln = oSchema.getNodeSchema(eParent).getChildRelnInfo(eTag);
        }
        if (oReln == null && oSchema.getNodeSchema(eParent).getChildRelnInfo(57).getRelationship() == null) {
            return new StringAttr("", "");
        }
        return this.getSchema().defaultAttribute(eTag, eParent);
    }

    public boolean getConfigValue(String sSOM, StringBuilder sValue) {
        BooleanHolder oRetBool = new BooleanHolder();
        Attribute oValue = this.getConfigValue(sSOM, oRetBool);
        if (oValue != null) {
            sValue.append(oValue);
        }
        return oRetBool.value;
    }

    @Override
    public int getHeadVersion() {
        return 35;
    }

    public Element getCommonNode(String sSchemaName) {
        Element oRoot = null;
        if (sSchemaName != null) {
            for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                Element element;
                if (!(child instanceof Element) || !(element = (Element)child).getName().equals(sSchemaName)) continue;
                oRoot = element;
            }
            sSchemaName = sSchemaName.intern();
        }
        int eTag = XFA.getTag(sSchemaName);
        if (oRoot != null) {
            if (!oRoot.isValidElement(51, false)) {
                return null;
            }
        } else {
            oRoot = eTag >= 0 && this.isValidElement(eTag, false) && eTag != 16 ? this.createElement(eTag, this.getName()) : this.createElement(16, sSchemaName);
        }
        return oRoot.getElement(51, 0);
    }

    Node createNodePath(String sSOMExpression, boolean bLeafIsKey) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "ConfigurationModel#createNodePath");
    }

    @Override
    public Element createElement(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int lineNumber, String fileName) {
        Element oElement = super.createElement(parent, prevSibling, uri, localName, qName, attributes, lineNumber, fileName);
        int eClassTag = oElement.getElementClass();
        if (eClassTag != -1) {
            if (eClassTag == 336) {
                oElement.isHidden(true);
            } else if (eClassTag == 185) {
                oElement.isHidden(true);
            }
        }
        return oElement;
    }

    public void mergeModel(ConfigurationModel oModel) {
        if (this.getLocked()) {
            return;
        }
        this.mergeNode(this, oModel);
    }

    @Override
    public int remapTag(int eTag) {
        return 57;
    }

    private void mergeNode(Node oDestNode, Node oSrcNode) {
        assert (oDestNode.getName() == oSrcNode.getName());
        if (oDestNode.getLocked()) {
            ExFull oErr = new ExFull(ResId.InvalidOverrideOperationException, oDestNode.getName());
            this.addErrorList(oErr, 3, this);
            return;
        }
        try {
            if (oDestNode instanceof ConfigurationValue && oSrcNode instanceof ConfigurationValue) {
                ((ConfigurationValue)oDestNode).setValue(((ConfigurationValue)oSrcNode).getValue());
                if (oDestNode instanceof ConfigurationUri) {
                    assert (oSrcNode instanceof ConfigurationUri);
                    ((ConfigurationUri)oDestNode).setConfigLocation(((ConfigurationUri)oSrcNode).getConfigLocation());
                }
                this.copyAttributes((Element)oDestNode, (Element)oSrcNode);
                return;
            }
            Node oParent = oSrcNode;
            for (Node oTemp = oSrcNode.getFirstXFAChild(); oTemp != null; oTemp = oTemp.getNextXFASibling()) {
                int eOccurs;
                ChildReln oChildReln;
                if (!(oTemp instanceof Element)) continue;
                Element oSrcChild = (Element)oTemp;
                boolean bMerge = false;
                String sSrcChildName = oSrcChild.getName();
                Node oDestChild = oDestNode.locateChildByName(sSrcChildName, 0);
                if (oDestChild != null) {
                    bMerge = true;
                }
                if ((oChildReln = ((Element)oParent).getChildReln(oSrcChild.getClassTag())) != null && (eOccurs = oChildReln.getOccurrence()) == 2 && !oSrcChild.isValidAttr(574, false, null)) {
                    NodeList oDestChildren;
                    Element oDuplicateFromNode;
                    if (oSrcChild.getName() == "equate" && (oDuplicateFromNode = this.equateFindDuplicateFrom(oDestChildren = oDestNode.getNodes(), oSrcChild)) != null) {
                        this.copyAttributes(oDuplicateFromNode, oSrcChild);
                        continue;
                    }
                    bMerge = false;
                }
                if (bMerge) {
                    this.mergeNode(oDestChild, oSrcChild);
                    this.copyAttributes((Element)oDestChild, oSrcChild);
                    oDestChild.makeNonDefault(false);
                    continue;
                }
                oSrcChild.clone((Element)oDestNode);
            }
        }
        catch (ExFull oEx) {
            this.addErrorList(oEx, 3, this);
        }
    }

    private void copyAttributes(Element oDestNode, Element oSrcNode) {
        if (oDestNode.getLocked()) {
            return;
        }
        int nSize = oSrcNode.getNumAttrs();
        for (int i = 0; i < nSize; ++i) {
            int eTag;
            String aAttr;
            Attribute domAttr = oSrcNode.getAttr(i);
            boolean bHandled = this.loadSpecialAttribute(domAttr, aAttr = domAttr.getLocalName(), oDestNode, false);
            if (bHandled || (eTag = XFA.getAttributeTag(aAttr)) == -1 || !oDestNode.isValidAttr(eTag, true, null)) continue;
            String sAttrVal = domAttr.getAttrValue();
            StringAttr oProperty = new StringAttr(aAttr, sAttrVal);
            oDestNode.setAttribute(oProperty, eTag);
        }
    }

    private Element equateFindDuplicateFrom(NodeList oDestChildren, Element oSrcChild) {
        Attribute oNodeAttr = oSrcChild.getAttribute(510);
        String sNodeAttr = oNodeAttr.toString();
        int i = 0;
        while (i < oDestChildren.length()) {
            Obj oTemp = oDestChildren.item(i);
            if (!(oTemp instanceof Element)) continue;
            Element oDestChild = (Element)oTemp;
            Attribute oAttr = oDestChild.getAttribute(510);
            String sAttr = oAttr.toString();
            if (sAttr.equals(sNodeAttr)) {
                return oDestChild;
            }
            ++i;
        }
        return null;
    }

    private void postLoadFixUp(Node node) {
        Element e;
        Attribute locked;
        Element parent;
        if (this.loadSpecialNode(node.getXFAParent(), node, false)) {
            return;
        }
        if (node.getClassTag() == 57) {
            if (node.getFirstXMLChild() == null) {
                parent = node.getXFAParent();
                ConfigurationValue cv = new ConfigurationValue(parent, node, 58, node.getName());
                parent.removeChild(node);
                node = cv;
            } else {
                Node child = node.getFirstXMLChild();
                if (child instanceof TextNode && child.getNextXMLSibling() == null) {
                    Element parent2 = node.getXFAParent();
                    ConfigurationValue cv = new ConfigurationValue(parent2, node, 58, node.getName());
                    cv.appendChild(child);
                    parent2.removeChild(node);
                    node = cv;
                }
            }
        }
        if (node instanceof ConfigurationValue) {
            try {
                ((ConfigurationValue)node).getValue();
            }
            catch (ExFull e2) {
                String sOldValue = "";
                Node textNode = node.getFirstXFAChild();
                if (textNode instanceof TextNode) {
                    sOldValue = ((TextNode)textNode).getValue();
                }
                String sNewValue = "";
                Element parent3 = node.getXFAParent();
                if (parent3 != null) {
                    Attribute newValue = this.getSchema().defaultAttribute(node.getClassTag(), parent3.getClassTag());
                    ((ConfigurationValue)node).setValue(newValue);
                    sNewValue = newValue.toString();
                }
                MsgFormatPos message = new MsgFormatPos(ResId.FoundBadElementValueException);
                message.format(sOldValue);
                message.format(node.getName());
                message.format(sNewValue);
                ExFull err = new ExFull(message);
                this.addErrorList(err, 3, this);
            }
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            int nAttributes = element.getNumAttrs();
            for (int i = 0; i < nAttributes; ++i) {
                Attribute attr = element.getAttr(i);
                this.loadSpecialAttribute(attr, attr.getLocalName(), element, false);
            }
        }
        if ((parent = node.getXFAParent()) != null && parent.getLocked()) {
            node.setLocked(true);
        } else if (node instanceof Element && (locked = (e = (Element)node).getAttribute(383, true, false)) != null && locked.getAttrValue().equals("1")) {
            e.setLocked(true);
        }
        Node child = node.getFirstXMLChild();
        while (child != null) {
            Node next = child.getNextXMLSibling();
            this.postLoadFixUp(child);
            child = next;
        }
    }

    @Override
    public boolean publish(Model.Publisher publisher) {
        HashMap<String, String> fileRefCache = new HashMap<String, String>();
        ConfigurationModel.publishNode(publisher, this, fileRefCache);
        return super.publish(publisher);
    }

    private static void publishNode(Model.Publisher publisher, Node node, Map<String, String> fileRefCache) {
        if (node.isSameClass(334) && (node.getXFAParent().isSameClass(360) || node.getXFAParent().isSameClass(218)) && node.getXFAChildCount() == 1) {
            TextNode textNode = (TextNode)node.getFirstXFAChild();
            String sFileRef = textNode.getValue();
            String sNewFileRef = fileRefCache.get(sFileRef);
            if (StringUtils.isEmpty(sNewFileRef)) {
                sNewFileRef = publisher.updateExternalRef(node, 0, sNewFileRef);
                fileRefCache.put(sFileRef, sNewFileRef);
            }
            if (!sFileRef.equals(sNewFileRef)) {
                textNode.setValue(sNewFileRef, true, false);
            }
        }
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            ConfigurationModel.publishNode(publisher, child, fileRefCache);
        }
    }

    @Override
    protected boolean canCreateChild(boolean bIsLeaf, String aName) {
        return true;
    }

    @Override
    protected Node createChild(boolean bIsLeaf, String aName) {
        int eClassTag = XFA.getTag(aName);
        Element oNode = eClassTag >= 0 && this.isValidElement(eClassTag, false) ? this.getModel().createElement(this, null, null, aName, aName, null, 0, null) : (bIsLeaf ? this.getModel().createElement(58, aName) : this.getModel().createElement(57, aName));
        return oNode;
    }
}

