/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.UriPath;
import com.adobe.xfa.configuration.ConfigurationUriScript;
import com.adobe.xfa.configuration.ConfigurationValue;
import java.net.URL;

public class ConfigurationUri
extends ConfigurationValue {
    private final UriPath mUriPath = new UriPath();

    public ConfigurationUri(Element parent, Node prevSibling) {
        super(parent, prevSibling);
        this.mUriPath.setRefFileLocation(parent.getOwnerDocument().getParseFile());
    }

    @Override
    public Element clone(Element parent, boolean deep) {
        ConfigurationUri oNew = (ConfigurationUri)super.clone(parent, deep);
        if (oNew != null) {
            oNew.setConfigLocation(this.getConfigLocation());
        }
        return oNew;
    }

    public URL getConfigLocation() {
        return this.mUriPath.getRefFileLocation();
    }

    public URL getFile() {
        return this.mUriPath.getFile(this.getValue(null).toString());
    }

    @Override
    public ScriptTable getScriptTable() {
        return ConfigurationUriScript.getScriptTable();
    }

    public void setConfigLocation(URL location) {
        this.mUriPath.setRefFileLocation(location);
    }

    @Override
    public void setValue(Attribute oData) {
        super.setValue(oData);
        this.mUriPath.setRefFileLocation(null);
    }
}

