/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.content.ContentScript;
import com.adobe.xfa.ut.StringUtils;
import org.xml.sax.Attributes;

public class Content
extends ProtoableNode {
    boolean mbIsNull;
    boolean mbIsNullDetermined;

    protected Content() {
    }

    protected Content(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int classTag, String className) {
        super(parent, prevSibling, uri, localName, qName, attributes, classTag, className);
        this.setSaveXMLSaveTransient(true);
    }

    @Override
    public void appendChild(Node poChild, boolean bValidate) {
        super.appendChild(poChild, bValidate);
        if (this.mbIsNullDetermined) {
            this.mbIsNullDetermined = false;
            this.removeXsiNilAttribute();
        }
    }

    @Override
    protected void childRemoved(Node poChild) {
        super.childRemoved(poChild);
        if (this.mbIsNullDetermined) {
            this.mbIsNullDetermined = false;
            this.removeXsiNilAttribute();
        }
    }

    public boolean couldBeNull() {
        if (this.getIsNull()) {
            return true;
        }
        Attribute attr = this.getXsiNilAttribute();
        if (attr != null) {
            return false;
        }
        return StringUtils.isEmpty(this.getStrValue());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Content content = (Content)object;
        if (!this.isSameClass(content.getClassTag())) {
            return false;
        }
        return this.getIsNull() == content.getIsNull();
    }

    public int hashCode() {
        return this.getIsNull() ? 0 : 31;
    }

    @Override
    public boolean getIsNull() {
        if (!this.mbIsNullDetermined) {
            this.mbIsNullDetermined = true;
            this.mbIsNull = false;
            Attribute attr = this.getXsiNilAttribute();
            if (attr != null) {
                this.mbIsNull = attr.getAttrValue().equals("true");
            } else if (this.getFirstXFAChild() == null) {
                this.mbIsNull = this.hasProto() ? this.getProto().getIsNull() : true;
            }
        }
        return this.mbIsNull;
    }

    public String getStrValue() {
        if (this.getIsNull()) {
            return "";
        }
        String sValue = "";
        TextNode poTextNode = this.getText(true, false, false);
        if (poTextNode != null) {
            sValue = poTextNode.getValue();
        }
        return sValue;
    }

    @Override
    public ScriptTable getScriptTable() {
        return ContentScript.getScriptTable();
    }

    @Override
    public void insertChild(Node poChild, Node poRefNode, boolean bValidate) {
        super.insertChild(poChild, poRefNode, bValidate);
        if (this.mbIsNullDetermined) {
            this.mbIsNullDetermined = false;
            this.removeXsiNilAttribute();
        }
    }

    @Override
    public void resetPostLoadXML() {
        this.mbIsNullDetermined = false;
        super.resetPostLoadXML();
    }

    public boolean sameText(Content compare) {
        boolean bRC = false;
        boolean bNull = this.getIsNull();
        boolean bOtherNull = compare.getIsNull();
        if (bNull && bOtherNull) {
            bRC = true;
        } else {
            String sOtherValue;
            String sValue = this.toString();
            if (sValue.equals(sOtherValue = compare.toString())) {
                bRC = true;
            }
        }
        return bRC;
    }

    public void setIsNull(boolean bNull, boolean bNotify, boolean bDefault) {
        if (this.getIsNull() == bNull) {
            return;
        }
        if (bNull) {
            this.setStrValue("", false, false);
            this.setXsiNilAttribute("true");
        } else {
            this.setXsiNilAttribute("false");
        }
        this.mbIsNullDetermined = true;
        this.mbIsNull = bNull;
        if (!bDefault) {
            this.makeNonDefault(false);
        }
        if (bNotify) {
            this.notifyPeers(2, "", null);
        }
    }

    public void setStrValue(String sText, boolean bNotify, boolean bDefault) {
        if (sText == null) {
            this.setIsNull(true, bNotify, false);
            return;
        }
        if (this.mbIsNullDetermined) {
            this.mbIsNull = false;
            this.removeXsiNilAttribute();
        }
        TextNode textNode = null;
        Node child = this.getFirstXFAChild();
        while (child != null) {
            Node nextChild = child.getNextXFASibling();
            if (textNode == null && child instanceof TextNode) {
                textNode = (TextNode)child;
            } else {
                child.remove();
            }
            child = nextChild;
        }
        if (textNode == null) {
            textNode = this.getText(false, true, false);
        }
        textNode.setValue(sText, false, bDefault);
        if (bNotify) {
            this.notifyPeers(2, "", null);
        }
    }

    public void setValue(String sValue, boolean bFromData, boolean bNotify, boolean bDefault) {
        this.setStrValue(sValue, bNotify, bDefault);
    }

    public String toString() {
        return this.getStrValue();
    }

    @Override
    protected boolean compareVersionsAttrHelper(Element oRollback, int eTag) {
        if (eTag == 457 && this.getModel() != null && this.getModel().getName() == "form") {
            Content oRollbackContent = (Content)oRollback;
            if (this.couldBeNull() && oRollbackContent != null && oRollbackContent.couldBeNull()) {
                return true;
            }
        }
        return super.compareVersionsAttrHelper(oRollback, eTag);
    }
}

