/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.ImageScript;
import com.adobe.xfa.ut.Base64;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;

public final class ImageValue
extends Content {
    private List<String> mpoImageSearchPath;

    public ImageValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "image", "image", null, 153, "image");
    }

    @Override
    public Attribute defaultAttribute(int eTag) {
        if (eTag == 457) {
            return new StringAttr("contentType", "image/*");
        }
        return super.defaultAttribute(eTag);
    }

    @Override
    public ProtoableNode createProto(Element parent, boolean bFull) {
        ProtoableNode proto = super.createProto(parent, bFull);
        if (proto instanceof ImageValue && this.getAppModel().getIsFragmentDoc()) {
            ImageValue imageProto = (ImageValue)proto;
            AppModel appModel = this.getAppModel();
            List<String> thisSearchPath = this.getImageSearchPath();
            List<String> fragmentSearchPath = appModel.getFragmentSearchPath();
            if (fragmentSearchPath != null || thisSearchPath != null) {
                ArrayList<String> concatenated = new ArrayList<String>();
                if (thisSearchPath != null) {
                    concatenated.addAll(thisSearchPath);
                }
                if (fragmentSearchPath != null && fragmentSearchPath.size() > 0) {
                    concatenated.addAll(fragmentSearchPath);
                }
                imageProto.mpoImageSearchPath = concatenated;
            }
        }
        return proto;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getValue().equals(((ImageValue)object).getValue());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getValue().hashCode();
    }

    private List<String> getImageSearchPath() {
        return this.mpoImageSearchPath;
    }

    @Override
    public boolean getIsNull() {
        if (this.isPropertySpecified(519, true, 0)) {
            Attribute attr;
            String sSource = "";
            sSource = this.getAttribute(519).toString();
            if (!(StringUtils.isEmpty(sSource) || (attr = this.getXsiNilAttribute()) != null && attr.getAttrValue().equals("true"))) {
                return false;
            }
        }
        return super.getIsNull();
    }

    @Override
    public ScriptTable getScriptTable() {
        return ImageScript.getScriptTable();
    }

    public String getValue() {
        String sSource = "";
        boolean bImageIsALink = this.isPropertySpecified(519, true, 0);
        if (bImageIsALink) {
            sSource = this.getAttribute(519).toString();
        }
        if (!bImageIsALink || StringUtils.isEmpty(sSource)) {
            sSource = this.getStrValue();
        }
        return sSource;
    }

    @Override
    public void setAttribute(Attribute oAttr, int eTag) {
        super.setAttribute(oAttr, eTag);
        if (eTag == 519 && oAttr != null) {
            this.setStrValue("", true, false);
        }
    }

    public void setValue(byte[] pImageBuffer, String sContentType) {
        this.setAttribute(new StringAttr("href", ""), 519);
        this.setAttribute(new StringAttr("contentType", sContentType), 457);
        this.setAttribute(3735553, 681);
        String sBase64 = Base64.encode(pImageBuffer, true);
        this.setStrValue(sBase64, true, false);
    }

    public void setValue(String sB64, String sContentType) {
        this.setAttribute(new StringAttr("href", ""), 519);
        if (!StringUtils.isEmpty(sContentType)) {
            this.setAttribute(new StringAttr("contentType", sContentType), 457);
        }
        this.setAttribute(3735553, 681);
        this.setStrValue(sB64, true, false);
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

