/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.Generator;
import com.adobe.xfa.Node;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.ResId;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public final class IncrementalLoader {
    public int mnLoadNodeLevel;
    private final Generator mGenerator;
    private DataNode mStartNode;
    private final List<Node> mParentStack = new ArrayList<Node>();
    private final List<Node> mResumeNodeStack = new ArrayList<Node>();
    private boolean mbBackOut;
    private int mnRecordLevel;
    private FileOutputStream mXSLStreamFile;
    private FileOutputStream mXSLDebugStreamFile;

    IncrementalLoader(DataModel dataModel, DataNode startNode, Generator generator) {
        this.mGenerator = generator;
        this.mStartNode = startNode;
        this.push(dataModel, startNode);
    }

    void push(Node parent, Node nextResumeNode) {
        this.mParentStack.add(parent);
        this.mResumeNodeStack.add(nextResumeNode);
    }

    void pop() {
        int size = this.mParentStack.size();
        assert (size > 0);
        assert (size == this.mResumeNodeStack.size());
        this.mParentStack.remove(size - 1);
        this.mResumeNodeStack.remove(size - 1);
    }

    Node getNext(ObjectHolder<Node> nextResumeNode) {
        int size = this.mParentStack.size();
        if (size == 0) {
            this.mStartNode = null;
            return null;
        }
        Node parent = this.mParentStack.get(size - 1);
        nextResumeNode.value = this.mResumeNodeStack.get(size - 1);
        this.pop();
        return parent;
    }

    boolean backOut() {
        return this.mbBackOut;
    }

    void backOut(boolean bBackOut) {
        this.mbBackOut = bBackOut;
    }

    Generator getGenerator() {
        return this.mGenerator;
    }

    boolean stackIsEmpty() {
        return this.mParentStack.size() == 0;
    }

    boolean isStartNode(DataNode node) {
        return this.mStartNode == node;
    }

    int recordDepth() {
        return this.mnRecordLevel;
    }

    void recordDepth(int nDepth) {
        this.mnRecordLevel = nDepth;
    }

    void XSLScriptFile(String scriptFile, String XSLDebugFile, String scriptString) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "IncrementalLoader#XSLScriptFile");
    }

    FileOutputStream XSLStream() {
        return this.mXSLStreamFile;
    }

    FileOutputStream XSLDebugStream() {
        return this.mXSLDebugStreamFile;
    }

    void createXSLDebugStream(String XSLDebugFile) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "IncrementalLoader#createXSLDebugStream");
    }
}

