/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.dom.AttrImpl;
import com.adobe.xfa.dom.ElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;

public class NamespaceContextImpl
implements NamespaceContext {
    private final ElementImpl mElementImpl;
    private Map<String, String> mNamespaceMappings;

    public NamespaceContextImpl(Node node) {
        ElementImpl element = null;
        if (node instanceof ElementImpl) {
            element = (ElementImpl)node;
        } else if ((node = node.getParentNode()) instanceof ElementImpl) {
            element = (ElementImpl)node;
        }
        this.mElementImpl = element;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String ns;
        if (prefix == null) {
            throw new IllegalArgumentException("prefix");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.mElementImpl != null) {
            Iterator<AttrImpl> i = this.mElementImpl.getNamespacesInScopeIterator();
            while (i.hasNext()) {
                AttrImpl attr = i.next();
                if (!prefix.equals(NamespaceContextImpl.extractPrefix(attr))) continue;
                return attr.getValue();
            }
        }
        if (this.mNamespaceMappings != null && (ns = this.mNamespaceMappings.get(prefix)) != null) {
            return ns;
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI");
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (this.mElementImpl != null) {
            Iterator<AttrImpl> i = this.mElementImpl.getNamespacesInScopeIterator();
            while (i.hasNext()) {
                AttrImpl attr = i.next();
                if (!attr.getValue().equals(namespaceURI)) continue;
                return NamespaceContextImpl.extractPrefix(attr);
            }
        }
        if (this.mNamespaceMappings != null) {
            for (Map.Entry<String, String> mapping : this.mNamespaceMappings.entrySet()) {
                if (!namespaceURI.equals(mapping.getValue())) continue;
                return mapping.getKey();
            }
        }
        if (namespaceURI.equals("")) {
            return "";
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI");
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            prefixes.add("xml");
        } else if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            prefixes.add("xmlns");
        } else {
            if (this.mElementImpl != null) {
                Iterator<AttrImpl> i = this.mElementImpl.getNamespacesInScopeIterator();
                while (i.hasNext()) {
                    AttrImpl attr = i.next();
                    if (!attr.getValue().equals(namespaceURI)) continue;
                    prefixes.add(NamespaceContextImpl.extractPrefix(attr));
                }
            }
            if (this.mNamespaceMappings != null) {
                for (Map.Entry<String, String> mapping : this.mNamespaceMappings.entrySet()) {
                    if (!namespaceURI.equals(mapping.getValue())) continue;
                    prefixes.add(mapping.getKey());
                }
            }
        }
        return prefixes.iterator();
    }

    public void addNamespaceMapping(String prefix, String namespaceURI) {
        if (this.mNamespaceMappings == null) {
            this.mNamespaceMappings = new HashMap<String, String>();
        }
        this.mNamespaceMappings.put(prefix, namespaceURI);
    }

    private static String extractPrefix(AttrImpl attr) {
        String prefix = attr.getName();
        int index = prefix.indexOf(58);
        return index != -1 ? prefix.substring(index + 1) : "";
    }
}

