/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.font;

import com.adobe.fontengine.font.Font;
import com.adobe.xfa.font.FontItem;
import com.adobe.xfa.ut.UnitSpan;

public class FontInstance
implements Comparable<FontInstance> {
    private final FontItem mFontItem;
    private final double mXScale;
    private final double mYScale;
    private final UnitSpan mUnitSize;
    private final double mHorizontalScale;
    private final double mVerticalScale;

    FontInstance(FontItem item, UnitSpan unitSize) {
        this(item, unitSize, 1.0, 1.0);
    }

    FontInstance(FontItem item, UnitSpan unitSize, double horizontalScale, double verticalScale) {
        this.mFontItem = item;
        this.mUnitSize = unitSize;
        this.mHorizontalScale = horizontalScale;
        this.mVerticalScale = verticalScale;
        double scale = (double)unitSize.valueAsUnit(19) / 1000.0;
        this.mXScale = scale * this.mHorizontalScale;
        this.mYScale = scale * this.mVerticalScale;
    }

    public FontItem getFontItem() {
        return this.mFontItem;
    }

    public Font getAFEFont() {
        return this.mFontItem.getAFEFont();
    }

    public String getTypeface() {
        return this.mFontItem == null ? null : this.mFontItem.getTypeface();
    }

    public int getWeight() {
        return this.mFontItem == null ? 400 : this.mFontItem.getWeight();
    }

    public boolean getItalic() {
        return this.mFontItem == null ? false : this.mFontItem.getItalic();
    }

    public UnitSpan getSize() {
        return this.mUnitSize;
    }

    public double getHorizontalScale() {
        return this.mHorizontalScale;
    }

    public double getVerticalScale() {
        return this.mVerticalScale;
    }

    public UnitSpan getAscent() {
        return this.toUnitSpanVertical(this.mFontItem.getAscent());
    }

    public UnitSpan getLegacyAscent() {
        return this.toUnitSpanVertical(this.mFontItem.getLegacyAscent());
    }

    public UnitSpan getDescent() {
        return this.toUnitSpanVertical(this.mFontItem.getDescent());
    }

    public UnitSpan getLineGap() {
        return this.toUnitSpanVertical(this.mFontItem.getLineGap());
    }

    public UnitSpan getLegacyLineGap() {
        return this.toUnitSpanVertical(this.mFontItem.getLegacyLineGap());
    }

    public UnitSpan getspacing() {
        return this.toUnitSpanVertical(this.mFontItem.getSpacing());
    }

    public float getCharWidth(int c, boolean useHorizontalGlyphs) {
        return (float)this.toDoubleHorizontal(this.mFontItem.getCharWidth(c, useHorizontalGlyphs));
    }

    public double getDoubleCharWidth(int c, boolean useHorizontalGlyphs) {
        assert (false);
        return 0.0;
    }

    public float getGlyphWidth(int glyphID, boolean useHorizontalGlyphs) {
        return (float)this.toDoubleHorizontal(this.mFontItem.getGlyphWidth(glyphID, useHorizontalGlyphs));
    }

    public int getGlyphID(int c) {
        return this.mFontItem.getGlyphID(c);
    }

    public boolean getGlyphID(int c, int g, boolean h) {
        assert (false);
        return false;
    }

    public void mapGlyph(int c, int glyphID) {
        this.mFontItem.mapGlyph(c, glyphID);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        FontInstance other = (FontInstance)object;
        return UnitSpan.match(this.mUnitSize, other.mUnitSize) && FontItem.match(this.mFontItem, other.mFontItem);
    }

    public int hashCode() {
        int result = this.mUnitSize == null ? 0 : this.mUnitSize.hashCode();
        result = result * 31 ^ (this.mFontItem == null ? 0 : this.mFontItem.hashCode());
        return result;
    }

    public static boolean match(FontInstance o1, FontInstance o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private final double toDoubleHorizontal(double value) {
        return value * this.mXScale;
    }

    private final double toDoubleVertical(double value) {
        return value * this.mYScale;
    }

    private final UnitSpan toUnitSpanVertical(double value) {
        return new UnitSpan(this.toDoubleVertical(value), 19);
    }

    @Override
    public int compareTo(FontInstance other) {
        if (other == null) {
            throw new NullPointerException();
        }
        int result = this.mFontItem.compareTo(other.mFontItem);
        return result != 0 ? result : this.mUnitSize.compareTo(other.getSize());
    }
}

