/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Delta;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormItemsDataListener;
import com.adobe.xfa.form.FormListener;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class FormField
extends Field {
    private FormDataListener mDataListener;
    private Object mCPDField;
    private FormItemsDataListener mItemsDataListener;
    private List<FormListener> mListenerTable;
    private boolean mbValidateRegistered;
    private boolean mbCalculateRegistered;
    private static final ThreadLocal<List<ExecEventRecursionRec>> execEventRecursionListThreadLocal = new ThreadLocal<List<ExecEventRecursionRec>>(){

        @Override
        protected List<ExecEventRecursionRec> initialValue() {
            return new ArrayList<ExecEventRecursionRec>();
        }
    };

    public FormField(Element parent, Node prevSibling) {
        super(parent, prevSibling);
    }

    @Override
    public void remove() {
        if (this.getModel() instanceof FormModel) {
            ((FormModel)this.getModel()).removeReferences(this);
        }
        super.remove();
    }

    void setDataNode(DataNode dataNode, boolean bUpdateData, boolean bPeerNode, String sConnectPicture, boolean bDefault) {
        if (this.mDataListener != null && bPeerNode) {
            this.mDataListener.dispose();
            this.mDataListener = null;
        }
        if (dataNode == null || dataNode.getClassTag() != 82) {
            return;
        }
        if (bPeerNode) {
            this.setFormDataListener(new FormDataListener(this, dataNode));
        }
        String sDataPictureFormat = "";
        if (bPeerNode) {
            TextNode textNode;
            Element picture;
            Element bind = this.getElement(364, true, 0, false, false);
            if (bind != null && (picture = bind.getElement(242, true, 0, false, false)) != null && (textNode = (TextNode)picture.locateChildByClass(0, 0)) != null) {
                sDataPictureFormat = textNode.getValue();
            }
        } else {
            sDataPictureFormat = sConnectPicture;
        }
        if (!StringUtils.isEmpty(sDataPictureFormat)) {
            ProtoableNode proto;
            Node content;
            boolean bIsTextNode = false;
            Element value = this.getElement(405, true, 0, false, false);
            if (value != null && (content = value.getOneOfChild(true, true)) != null && content.isSameClass(398)) {
                bIsTextNode = true;
            }
            String sLocale = (proto = this.getProto()) != null ? proto.getInstalledLocale() : this.getInstalledLocale();
            if (bPeerNode) {
                this.getDataNode().setPictureFormat(sDataPictureFormat, sLocale, bIsTextNode);
            } else {
                dataNode.setPictureFormat(sDataPictureFormat, sLocale, bIsTextNode);
            }
        }
        if (bPeerNode && this.getFormDataListener() != null) {
            this.getFormDataListener().deafen();
        }
        if (bUpdateData) {
            this.setData(dataNode);
        } else {
            this.setFromData(dataNode, bDefault);
        }
        if (bPeerNode && this.getFormDataListener() != null) {
            this.getFormDataListener().unDeafen();
        }
    }

    void setData(DataNode dataValue) {
        if (dataValue == null && (dataValue = this.getDataNode()) == null) {
            return;
        }
        if (this.getIsNull(false)) {
            dataValue.setIsNull(true, true);
            return;
        }
        Element value = this.getElement(405, false, 0, false, false);
        Node valueContent = value.getOneOfChild();
        if (valueContent instanceof Content) {
            Content content = (Content)valueContent;
            Node valueContentChild = null;
            if (valueContent.isSameClass(153)) {
                Attribute contentType = content.getAttribute(457);
                dataValue.setContentType(contentType.toString());
                if (valueContent.isPropertySpecified(519, true, 0)) {
                    Attribute href = content.getAttribute(519);
                    dataValue.setAttribute("", "href", "href", href.getAttrValue(), false);
                }
            }
            boolean bIsValueContentExData = false;
            if (dataValue.getContentType().equals("text/html")) {
                bIsValueContentExData = true;
            }
            if ((valueContentChild = valueContent.isSameClass(125) ? content.getOneOfChild(true, false) : content.getText(true, false, false)) != null) {
                if (valueContentChild instanceof TextNode && !bIsValueContentExData) {
                    dataValue.setValue(((TextNode)valueContentChild).getValue(), true);
                } else if (valueContentChild.isSameClass(1) || bIsValueContentExData) {
                    dataValue.clearNull();
                    if (dataValue.isAttribute()) {
                        ExDataValue exData = (ExDataValue)valueContent;
                        String sValue = exData.getStrValue();
                        dataValue.setValue(sValue, true);
                    } else {
                        Node importedNode = dataValue.getOwnerDocument().importNode(valueContentChild, true);
                        Node oldNode = dataValue.getFirstXMLChild();
                        if (oldNode != null) {
                            dataValue.replaceChild(importedNode, oldNode);
                        } else {
                            dataValue.appendChild(importedNode, false);
                        }
                    }
                    dataValue.deafen();
                    dataValue.notifyPeers(2, "", null);
                    dataValue.unDeafen();
                }
            }
        }
    }

    @Override
    public DataNode getDataNode() {
        if (null != this.getFormDataListener()) {
            return this.getFormDataListener().getDataNode();
        }
        return null;
    }

    protected void setFormDataListener(FormDataListener dataListener) {
        if (this.mDataListener != null) {
            this.mDataListener.dispose();
        }
        this.mDataListener = dataListener;
    }

    protected FormDataListener getFormDataListener() {
        return this.mDataListener;
    }

    List<FormListener> getFormListeners(boolean bCreate) {
        if (bCreate && this.mListenerTable == null) {
            this.mListenerTable = new ArrayList<FormListener>();
        }
        return this.mListenerTable;
    }

    void setItemsDataListener(FormItemsDataListener listener) {
        this.mItemsDataListener = listener;
    }

    FormItemsDataListener getItemsDataListener() {
        return this.mItemsDataListener;
    }

    void cleanupListeners() {
        if (this.mDataListener != null) {
            this.mDataListener.dispose();
            this.mDataListener = null;
        }
        if (this.mItemsDataListener != null) {
            this.mItemsDataListener.dispose();
            this.mItemsDataListener = null;
        }
        if (this.mListenerTable != null) {
            this.mListenerTable.clear();
            this.mListenerTable = null;
        }
    }

    void resetData() {
        ProtoableNode proto = this.getProto();
        if (proto == null) {
            return;
        }
        Element value = proto.getElement(405, true, 0, false, false);
        this.setElement(value, 405, 0);
        Element value2 = this.getElement(405, false, 0, false, false);
        Node content = value2.getOneOfChild();
        this.notifyPeers(7, "", content);
    }

    public Object getCPDField() {
        return this.mCPDField;
    }

    public void setCPDField(Object oCPDField) {
        this.mCPDField = oCPDField;
    }

    @Override
    public void getDeltas(Element delta, XFAList list) {
        if (!this.isSameClass(delta)) {
            return;
        }
        FormModel model = (FormModel)this.getModel();
        if (model.isLoading()) {
            Element deltaValue = delta.getElement(405, true, 0, false, false);
            if (deltaValue != null) {
                Element value = this.getElement(405, false, 0, false, false);
                XFAList list2 = new XFAList();
                value.getDeltas(deltaValue, list2);
                int nLen = list2.length();
                for (int i = 0; i < nLen; ++i) {
                    Delta valueDelta = (Delta)list2.item(i);
                    valueDelta.restore();
                }
            }
            model.restoreValidateDisableAll(this, delta);
        }
        super.getDeltas(delta, list);
    }

    void setFromData(DataNode dataValue, boolean bDefault) {
        String sDataValueContentType;
        if (dataValue == null) {
            bDefault = false;
            dataValue = this.getDataNode();
            if (dataValue == null) {
                return;
            }
        }
        boolean bIsRichText = false;
        boolean bDataIsNull = dataValue.getIsNull();
        Element value = this.getElement(405, 0);
        Element valueContent = (Element)value.getOneOfChild();
        if (valueContent.isSameClass(125)) {
            bIsRichText = true;
            sDataValueContentType = dataValue.getContentType();
            String sContentType = valueContent.getAttribute(457).toString();
            if (StringUtils.isEmpty(sDataValueContentType)) {
                sDataValueContentType = !bDataIsNull ? "text/plain" : sContentType;
            }
            if (StringUtils.isEmpty(sContentType) || !sDataValueContentType.equals(sContentType)) {
                if (sDataValueContentType.equals("text/plain")) {
                    valueContent.setAttribute(new StringAttr("contentType", sDataValueContentType), 457);
                } else if (sDataValueContentType.equals("text/html")) {
                    bIsRichText = true;
                } else {
                    MsgFormatPos oFormatPos = new MsgFormatPos(ResId.IncompatibleContentType);
                    oFormatPos.format(sDataValueContentType);
                    oFormatPos.format("exData");
                    ExFull oEx = new ExFull(oFormatPos);
                    this.getModel().addErrorList(oEx, 2, this);
                }
            } else if (sContentType.equals("text/html")) {
                bIsRichText = true;
            }
        } else if (valueContent.isSameClass(153)) {
            String sDataValue;
            valueContent = (Element)value.getOneOfChild();
            sDataValueContentType = dataValue.getContentType();
            if (StringUtils.isEmpty(sDataValueContentType)) {
                sDataValueContentType = "image/*";
            }
            if (!(sDataValueContentType.equals("text/plain") || sDataValueContentType.contains("image/") || StringUtils.isEmpty(sDataValue = dataValue.getValue(false)))) {
                MsgFormatPos formatPos = new MsgFormatPos(ResId.IncompatibleContentType);
                formatPos.format(sDataValueContentType);
                formatPos.format("image");
                ExFull ex = new ExFull(formatPos);
                this.getModel().addErrorList(ex, 2, this);
            }
            valueContent.setAttribute(new StringAttr("contentType", sDataValueContentType), 457);
            String href = null;
            int index = dataValue.findAttr("", "href");
            if (index != -1) {
                href = dataValue.getAttrVal(index);
            }
            valueContent.setAttribute(new StringAttr("href", href != null ? href : ""), 519);
            index = dataValue.findAttr("", "transferEncoding");
            if (index != -1) {
                StringAttr attr = new StringAttr("transferEncoding", dataValue.getAttrVal(index));
                valueContent.setAttribute(attr, 681);
            }
        }
        if (bDataIsNull) {
            this.setIsNull(true, true);
            return;
        }
        if (bIsRichText) {
            Node dvNode = dataValue.getXmlPeer();
            ExDataValue exData = (ExDataValue)valueContent;
            if (dataValue.isAttribute()) {
                exData.setStrValue(dataValue.getValue(), true, bDefault);
            } else {
                Element fvNode = valueContent;
                Node dvNodeValue = dvNode.getFirstXMLChild();
                if (dvNodeValue == null) {
                    exData.setStrValue(dataValue.getValue(), true, bDefault);
                } else {
                    Node importedNode = fvNode.getOwnerDocument().importNode(dvNodeValue, true);
                    exData.setContent(importedNode, true);
                }
            }
        } else if (this.getAppModel().getLegacySetting(AppModel.XFA_PATCH_W_2757988)) {
            ((Content)valueContent).setStrValue(dataValue.getValue(), true, bDefault);
        } else {
            ((Content)valueContent).setValue(dataValue.getValue(), true, true, bDefault);
        }
    }

    @Override
    public boolean getIsNull() {
        return this.getIsNull(true);
    }

    private boolean getIsNull(boolean bCheckData) {
        DataNode dataNode = this.getDataNode();
        if (bCheckData && dataNode != null) {
            return dataNode.getIsNull();
        }
        Element value = this.getElement(405, true, 0, false, false);
        if (value != null) {
            Node oneOfChild = value.getOneOfChild(true, false);
            if (oneOfChild == null) {
                return true;
            }
            if (!(oneOfChild instanceof Content)) {
                return true;
            }
            Content content = (Content)oneOfChild;
            if (content.getIsNull()) {
                return true;
            }
            if (!content.couldBeNull()) {
                return false;
            }
        } else {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execEvent(String sActivity) {
        List<ExecEventRecursionRec> execEventRecursionList = execEventRecursionListThreadLocal.get();
        int isize = execEventRecursionList.size();
        for (int i = 0; i < isize; ++i) {
            ExecEventRecursionRec r = execEventRecursionList.get(i);
            if (!r.equals(this, sActivity)) continue;
            return;
        }
        execEventRecursionList.add(new ExecEventRecursionRec(this, sActivity));
        try {
            FormModel formModel = (FormModel)this.getModel();
            formModel.eventOccurred(sActivity, this);
        }
        finally {
            execEventRecursionList.remove(execEventRecursionList.size() - 1);
        }
    }

    @Override
    public boolean execValidate() {
        FormModel formModel = (FormModel)this.getModel();
        FormModel.Validate validate = formModel.getDefaultValidate();
        formModel.validate(validate, this, false, false);
        return validate == null || validate.getFailCount() <= 0;
    }

    public boolean getRegistered(int eActivity) {
        if (eActivity == 404) {
            return this.mbValidateRegistered;
        }
        if (eActivity == 36) {
            return this.mbCalculateRegistered;
        }
        return false;
    }

    void setRegistered(int eActivity) {
        if (eActivity == 404) {
            this.mbValidateRegistered = true;
        } else if (eActivity == 36) {
            this.mbCalculateRegistered = true;
        }
    }

    @Override
    public void notifyPeers(int eventType, String arg1, Object pArg2) {
        if (this.getModel() != null && this.getModel().isLoading()) {
            return;
        }
        if (!this.mbValidateRegistered && pArg2 instanceof FormModel.Validate && (eventType == 6 || eventType == 8)) {
            FormModel poFormModel = (FormModel)this.getModel();
            poFormModel.registerEvents(this, 4);
        }
        super.notifyPeers(eventType, arg1, pArg2);
    }

    void updateItemsFromData(Element bindItems, boolean bIsConnectionBind) {
        boolean bMarkAsDefault;
        NodeList refNodes;
        Attribute valueRef;
        Element ui = this.getElement(331, true, 0, false, false);
        if (ui == null) {
            return;
        }
        Node currentUI = ui.getOneOfChild(true, false);
        if (currentUI == null || !currentUI.isSameClass("choiceList")) {
            return;
        }
        if (bindItems == null || !bindItems.isSameClass(31)) {
            return;
        }
        String sLabelRef = "";
        String sValueRef = "";
        Attribute labelRef = bindItems.getAttribute(537, true, false);
        if (labelRef != null) {
            sLabelRef = labelRef.toString();
        }
        if ((valueRef = bindItems.getAttribute(701, true, false)) != null) {
            sValueRef = valueRef.toString();
        }
        if (sValueRef.length() == 0 && sLabelRef.length() == 0) {
            return;
        }
        String sRef = "";
        Attribute ref = bindItems.getAttribute(392, true, false);
        if (ref != null) {
            sRef = ref.toString();
        }
        if (sRef.length() == 0 && !bIsConnectionBind) {
            this.updateItemsFromDatabase(bindItems, sValueRef, sLabelRef);
            return;
        }
        if (sRef.length() == 0) {
            return;
        }
        Element dataNode = null;
        if (bIsConnectionBind) {
            for (Element node = this; node != null; node = node.getXFAParent()) {
                if (node instanceof Container && ((Container)node).getFormInfo() != null) {
                    dataNode = ((Container)node).getFormInfo().connectionDataNode;
                }
                if (dataNode == null) {
                    continue;
                }
                break;
            }
        } else {
            dataNode = this.getDataNode();
        }
        if ((refNodes = dataNode != null ? dataNode.resolveNodes(sRef, true, false, true) : this.resolveNodes(sRef, true, false, true)).length() == 0) {
            return;
        }
        boolean bMultiColumn = true;
        if (sValueRef.length() == 0 || sLabelRef.length() == 0) {
            bMultiColumn = false;
        }
        Field.ItemPair itemPair = new Field.ItemPair();
        this.getItemLists(false, itemPair, bMultiColumn);
        Items displayItems = itemPair.mDisplayItems;
        Items saveItems = itemPair.mSaveItems;
        boolean bl = bMarkAsDefault = !bIsConnectionBind;
        if (displayItems != null) {
            displayItems.clearItems(bMarkAsDefault);
        }
        if (saveItems != null) {
            saveItems.clearItems(bMarkAsDefault);
        }
        FormItemsDataListener listener = this.getItemsDataListener();
        int nItems = refNodes.length();
        for (int i = 0; i < nItems; ++i) {
            Node valueNode;
            Node labelNode;
            Node refNode = (Node)refNodes.item(i);
            String sDisplayText = "";
            String sSaveText = "";
            if (sLabelRef.length() != 0 && (labelNode = refNode.resolveNode(sLabelRef, true, false, false)) != null && labelNode.isSameClass(82)) {
                sDisplayText = ((DataNode)labelNode).getValue();
                if (listener != null) {
                    listener.addDataNode(labelNode, true);
                }
            }
            if (sValueRef.length() != 0 && (valueNode = refNode.resolveNode(sValueRef, true, false, false)) != null && valueNode.isSameClass(82)) {
                sSaveText = ((DataNode)valueNode).getValue();
                if (listener != null) {
                    listener.addDataNode(valueNode, true);
                }
            }
            if (listener != null) {
                listener.addDataNode(refNode, false);
            }
            if (!bMultiColumn) {
                String sText = sDisplayText;
                if (sLabelRef.length() == 0) {
                    sText = sSaveText;
                }
                sSaveText = sText;
            }
            if (displayItems != null) {
                displayItems.addItem(sDisplayText, bMarkAsDefault);
            }
            if (saveItems == null || saveItems == displayItems) continue;
            saveItems.addItem(sSaveText, bMarkAsDefault);
        }
        Node refNode = (Node)refNodes.item(0);
        Element refParent = refNode.getXFAParent();
        if (refParent != null && listener != null) {
            listener.addDataNode(refParent, false);
        }
    }

    void updateItemsFromDatabase(Element bindItems, String sValueRef, String sLabelRef) {
        String sConnection = "";
        Attribute connection = bindItems.getAttribute(371, true, false);
        if (connection != null) {
            sConnection = connection.toString();
        }
        if (sConnection.length() == 0) {
            return;
        }
        DataModel dataModel = DataModel.getDataModel(this.getAppModel(), false, false);
        if (dataModel == null) {
            return;
        }
        DataModel.SourceSetLink link = dataModel.getSourceSetLink();
        if (link == null || !link.isSource(this, sConnection)) {
            return;
        }
        List<Object> valueData = new ArrayList();
        List<Object> labelData = new ArrayList();
        if (sValueRef.length() != 0) {
            valueData = link.getColumnData(this, sConnection, sValueRef);
        }
        if (sLabelRef.length() != 0) {
            labelData = link.getColumnData(this, sConnection, sLabelRef);
        }
        if (valueData.size() == 0 && labelData.size() == 0) {
            return;
        }
        boolean bMultiColumn = true;
        int nItemCount = 0;
        if (valueData.size() != 0 && labelData.size() != 0) {
            nItemCount = valueData.size();
            if (labelData.size() < nItemCount) {
                nItemCount = labelData.size();
            }
        } else if (valueData.size() != 0) {
            nItemCount = valueData.size();
            bMultiColumn = false;
        } else {
            valueData = labelData;
            nItemCount = valueData.size();
            bMultiColumn = false;
        }
        Field.ItemPair itemPair = new Field.ItemPair();
        this.getItemLists(false, itemPair, bMultiColumn);
        Items displayItems = itemPair.mDisplayItems;
        Items saveItems = itemPair.mSaveItems;
        if (displayItems != null) {
            displayItems.clearItems(true);
        }
        if (saveItems != null) {
            saveItems.clearItems(true);
        }
        for (int i = 0; i < nItemCount; ++i) {
            String sSaveText;
            String sDisplayText;
            if (bMultiColumn) {
                sDisplayText = (String)labelData.get(i);
                sSaveText = (String)valueData.get(i);
            } else {
                sDisplayText = (String)valueData.get(i);
                sSaveText = (String)valueData.get(i);
            }
            if (displayItems != null) {
                displayItems.addItem(sDisplayText, true);
            }
            if (saveItems == null || saveItems == displayItems) continue;
            saveItems.addItem(sSaveText, true);
        }
    }

    private static class ExecEventRecursionRec {
        protected final FormField formfield;
        protected final String msActivity;

        public ExecEventRecursionRec(FormField formfield, String sActivity) {
            this.formfield = formfield;
            this.msActivity = sActivity;
        }

        public boolean equals(FormField aformfield, String sActivity) {
            return this.formfield == aformfield && this.msActivity.equals(sActivity);
        }
    }
}

