/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.font.FontService;
import com.adobe.xfa.gfx.GFXDevPoint;
import com.adobe.xfa.gfx.GFXDevRect;
import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXFillAttr;
import com.adobe.xfa.gfx.GFXModelContext;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

public abstract class GFXEnv {
    public static final int FIT_LEFT = 1;
    public static final int FIT_CENTRE = 2;
    public static final int FIT_RIGHT = 3;
    public static final int FIT_TOP = 4;
    public static final int FIT_MIDDLE = 8;
    public static final int FIT_BOTTOM = 12;
    private static final int IC_ASKDRIVER = 0;
    private static final int IC_INTERACTIVE = 1;
    private static final int IC_NONINTERACTIVE = 2;
    private final boolean mbEraseBg;
    private final GFXFillAttr moBackground;
    private boolean mbDefaultColours;
    private boolean mbDisplayAsPages;
    private final boolean mbInfoEnv;
    private int mnInteractive;
    private boolean mbLegacyPositioning;
    private FontService mpoFontService;

    public GFXEnv(boolean bInfoEnv) {
        this.mbInfoEnv = bInfoEnv;
        this.mbEraseBg = true;
        this.moBackground = new GFXFillAttr(GFXFillAttr.WHITE_FILL);
        this.mbDefaultColours = true;
        this.mnInteractive = 0;
        this.mbDisplayAsPages = true;
    }

    public GFXEnv() {
        this(false);
    }

    public GFXFillAttr background() {
        return this.moBackground;
    }

    public void background(GFXFillAttr oBackground) {
        this.moBackground.copyFrom(oBackground);
    }

    public boolean defaultColours() {
        return this.mbDefaultColours;
    }

    public void defaultColours(boolean bDefaultColours) {
        this.mbDefaultColours = bDefaultColours;
    }

    public boolean draw3dEffects() {
        return this.driver().draw3dEffects();
    }

    public void draw3dEffects(boolean b3dEffects) {
        this.driver().draw3dEffects(b3dEffects);
    }

    public boolean displayAsPages() {
        return this.mbDisplayAsPages;
    }

    public void displayAsPages(boolean bDisplayAsPages) {
        this.mbDisplayAsPages = bDisplayAsPages;
    }

    public int devH(UnitSpan oHeight) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.devH(oHeight);
    }

    public GFXDevPoint devPoint(CoordPair oPoint) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.devPoint(oPoint);
    }

    public GFXDevRect devRect(Rect oRect) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.devRect(oRect);
    }

    public int devW(UnitSpan oWidth) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.devW(oWidth);
    }

    public int devX(UnitSpan oX) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.devX(oX);
    }

    public int devY(UnitSpan oY) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.devY(oY);
    }

    public GFXDriver driverAttach() {
        return this.validDriver();
    }

    public GFXDriver driverAttach(GFXModelContext poModelContext) {
        return this.driverAttach();
    }

    public void driverDetach() {
    }

    public void driverDetach(GFXModelContext poModelContext) {
        this.driverDetach();
    }

    public boolean eraseBg() {
        return this.mbEraseBg;
    }

    public void fit(double dScale, CoordPair oOrigin, int nFit, boolean bInvalidate) {
        GFXDriver poDriver = this.driverAttach();
        poDriver.fit(dScale, oOrigin, nFit);
        this.driverDetach();
    }

    public void fit(double dScale, CoordPair oOrigin, int nFit) {
        this.fit(dScale, oOrigin, nFit, false);
    }

    public void fitPage(Rect oPageRect) {
        GFXDriver poDriver = this.validDriver();
        UnitSpan oWidth = poDriver.widthInUnits();
        UnitSpan oHeight = poDriver.heightInUnits();
        double dScale = oWidth.divide(oPageRect.width());
        double dScaleY = oHeight.divide(oPageRect.height());
        if (dScaleY < dScale) {
            dScale = dScaleY;
        }
        this.fit(dScale, oPageRect.topLeft(), 5);
    }

    public void fitSides(UnitSpan oLeft, UnitSpan oRight, UnitSpan oY, int nFit) {
        UnitSpan oFitWidth = oRight.subtract(oLeft);
        if (oFitWidth.value() == 0) {
            // empty if block
        }
        GFXDriver poDriver = this.validDriver();
        UnitSpan oWidth = poDriver.widthInUnits();
        double dScale = oWidth.divide(oFitWidth);
        this.fit(dScale, new CoordPair(oLeft, oY), nFit & 0xC | 1);
    }

    public FontService fontService() {
        return this.mpoFontService;
    }

    public void fontService(FontService poNewService) {
        this.mpoFontService = poNewService;
    }

    public GFXDriver getDriver() {
        return this.validDriver();
    }

    public int height() {
        GFXDriver poDriver = this.driverAttach();
        int lHeight = poDriver.height();
        this.driverDetach();
        return lHeight;
    }

    public UnitSpan heightInAbsUnits() {
        GFXDriver poDriver = this.driverAttach();
        UnitSpan oHeight = poDriver.heightInUnits();
        this.driverDetach();
        return oHeight;
    }

    public boolean infoEnv() {
        return this.mbInfoEnv;
    }

    public boolean interactive() {
        if (this.mnInteractive == 0) {
            GFXDriver poDriver = this.driverAttach();
            boolean bInteractive = poDriver.interactive();
            this.driverDetach();
            this.mnInteractive = bInteractive ? 1 : 2;
        }
        return this.mnInteractive == 1;
    }

    public void interactive(boolean bInteractive) {
        this.mnInteractive = bInteractive ? 1 : 2;
    }

    public boolean legacyPositioning() {
        return this.mbLegacyPositioning;
    }

    public void legacyPositioning(boolean bLegacyPositioning) {
        this.mbLegacyPositioning = bLegacyPositioning;
    }

    public void invalidateArea(GFXModelContext poModelContext, Rect oInvalidArea, boolean bEraseBG) {
    }

    public void refresh() {
    }

    public double scale() {
        GFXDriver poDriver = this.validDriver();
        return poDriver.scale();
    }

    public UnitSpan unitH(int lHeight) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.unitH(lHeight);
    }

    public CoordPair unitPoint(int lX, int lY) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.unitPoint(lX, lY);
    }

    public Rect unitRect(int lLeft, int lTop, int lRight, int lBottom) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.unitRect(lLeft, lTop, lRight, lBottom);
    }

    public UnitSpan unitW(int lWidth) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.unitW(lWidth);
    }

    public UnitSpan unitX(int lX) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.unitX(lX);
    }

    public UnitSpan unitY(int lY) {
        GFXDriver poDriver = this.validDriver();
        return poDriver.unitY(lY);
    }

    public Rect visibleArea() {
        GFXDriver poDriver = this.driverAttach();
        Rect oVisibleArea = poDriver.visibleArea();
        this.driverDetach();
        return oVisibleArea;
    }

    public int width() {
        GFXDriver poDriver = this.driverAttach();
        int lWidth = poDriver.width();
        this.driverDetach();
        return lWidth;
    }

    public UnitSpan widthInAbsUnits() {
        GFXDriver poDriver = this.driverAttach();
        UnitSpan oWidth = poDriver.widthInUnits();
        this.driverDetach();
        return oWidth;
    }

    public GFXDriver validDriver() {
        GFXDriver poDriver = this.driver();
        return poDriver;
    }

    protected abstract GFXDriver driver();
}

