/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.gfx.GFXAttr;
import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.gfx.GFXDecorationInfo;
import com.adobe.xfa.gfx.GFXTextContext;

public class GFXTextAttr
extends GFXAttr {
    public static final int UNDER_TYPE = 15;
    public static final int UNDER_UNKNOWN = 0;
    public static final int UNDER_NONE = 1;
    public static final int UNDER_ALL = 2;
    public static final int UNDER_WORD = 3;
    public static final int UNDER_STYLE = 240;
    public static final int UNDER_SINGLE = 16;
    public static final int UNDER_DOUBLE = 32;
    public static final int LINETHROUGH_TYPE = 15;
    public static final int LINETHROUGH_UNKNOWN = 0;
    public static final int LINETHROUGH_NONE = 1;
    public static final int LINETHROUGH_ALL = 2;
    public static final int LINETHROUGH_WORD = 3;
    public static final int LINETHROUGH_STYLE = 240;
    public static final int LINETHROUGH_SINGLE = 16;
    public static final int LINETHROUGH_DOUBLE = 32;
    public static final int OVER_TYPE = 15;
    public static final int OVER_UNKNOWN = 0;
    public static final int OVER_NONE = 1;
    public static final int OVER_ALL = 2;
    public static final int OVER_WORD = 3;
    public static final int OVER_STYLE = 240;
    public static final int OVER_SINGLE = 16;
    public static final int OVER_DOUBLE = 32;
    public static final int STRIKEOUT_UNKNOWN = 0;
    public static final int STRIKEOUT_NONE = 1;
    public static final int STRIKEOUT_SINGLE = 18;
    public static final int STRIKEOUT_DOUBLE = 34;
    public static final GFXTextAttr defaultTextAttr = new GFXTextAttr(1, 2, GFXAttr.defaultShadeScale(), GFXColour.black(), GFXColour.white());
    private int mnUnderline;
    private int mnOverline;
    private int mnStrikeout;
    private GFXTextContext mpoContext;

    public GFXTextAttr() {
        this.mnUnderline = 1;
        this.mnOverline = 1;
        this.mnStrikeout = 1;
    }

    public GFXTextAttr(GFXTextAttr oSource) {
        this.copyFrom(oSource);
    }

    public GFXTextAttr(int nNewUnderline, int nNewStyle, int lNewShade, GFXColour oNewColour, GFXColour oNewColourBg) {
        super(nNewStyle, lNewShade, oNewColour, oNewColourBg);
        this.mnUnderline = nNewUnderline;
        this.mnOverline = 1;
        this.mnStrikeout = 1;
    }

    public GFXTextAttr(int nNewUnderline, int nNewStyle, int lNewShade, GFXColour oNewColour, GFXColour oNewColourBg, int nNewStrikeout, int nNewOverline) {
        this(nNewUnderline, nNewStyle, lNewShade, oNewColour, oNewColourBg);
        this.mnUnderline = nNewUnderline;
        this.mnStrikeout = nNewStrikeout;
    }

    public static GFXTextAttr defaultText() {
        return defaultTextAttr;
    }

    public int underline() {
        return this.mnUnderline;
    }

    public void underline(int nNewUnderline) {
        this.mnUnderline = nNewUnderline;
    }

    public int overline() {
        return this.mnOverline;
    }

    public void overline(int nNewOverline) {
        this.mnOverline = nNewOverline;
    }

    public int strikeout() {
        return this.mnStrikeout;
    }

    public void strikeout(int nNewStrikeout) {
        this.mnStrikeout = nNewStrikeout;
    }

    public GFXTextContext textContext() {
        return this.mpoContext;
    }

    public void textContext(GFXTextContext poTextContext) {
        this.mpoContext = poTextContext;
    }

    public boolean equivalent(GFXTextAttr oCompare) {
        return super.equivalent(oCompare) && this.mnOverline == oCompare.mnOverline && this.mnUnderline == oCompare.mnUnderline && this.mnStrikeout == oCompare.mnStrikeout && GFXTextContext.match(this.mpoContext, oCompare.mpoContext);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GFXTextAttr)) {
            return false;
        }
        return this.equivalent((GFXTextAttr)object);
    }

    @Override
    public int hashCode() {
        int hash = 41;
        hash = hash * 31 ^ super.hashCode();
        hash = hash * 31 ^ this.mnOverline;
        hash = hash * 31 ^ this.mnUnderline;
        hash = hash * 31 ^ this.mnStrikeout;
        hash = hash * 31 ^ this.mpoContext.hashCode();
        return hash;
    }

    public boolean notEqual(Object oCompare) {
        return !this.equals(oCompare);
    }

    public void copyFrom(GFXTextAttr oSource) {
        if (this != oSource) {
            super.copyFrom(oSource);
            this.mnOverline = oSource.mnOverline;
            this.mnUnderline = oSource.mnUnderline;
            this.mnStrikeout = oSource.mnStrikeout;
            this.mpoContext = oSource.mpoContext;
        }
    }

    public static GFXDecorationInfo extractDecoration(int nDecoration) {
        return GFXDecorationInfo.extractDecoration(nDecoration);
    }
}

