/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.datamatrixpmp;

import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixBaseCompactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixPadder;

class DataMatrixByteCompactor
extends DataMatrixBaseCompactor {
    private static final int BASE256LATCH = 231;

    DataMatrixByteCompactor() {
    }

    void compact(char[] message) {
        this.m_codeWords.clear();
        this.m_valid = false;
        int position = 2;
        int messageSize = message.length;
        if (messageSize < 1) {
            return;
        }
        this.m_codeWords.add(231);
        if (messageSize <= 249) {
            this.m_codeWords.add(DataMatrixByteCompactor.State255Randomize(messageSize, position++));
        } else if (messageSize <= 1555) {
            int d1 = messageSize / 250 + 249;
            int d2 = messageSize % 250;
            this.m_codeWords.add(DataMatrixByteCompactor.State255Randomize(d1, position++));
            this.m_codeWords.add(DataMatrixByteCompactor.State255Randomize(d2, position++));
        } else {
            return;
        }
        for (int idx = 0; idx < messageSize; ++idx) {
            this.m_codeWords.add(DataMatrixByteCompactor.State255Randomize(message[idx], position++));
        }
        this.m_symbolSize = this.findSymbolSize(this.m_codeWords.size());
        if (this.m_symbolSize == -1) {
            return;
        }
        DataMatrixPadder.addPadding(this.m_codeWords, this.m_symbolSize);
        this.m_valid = true;
    }

    static int State255Randomize(int codeWord, int position) {
        int random = 149 * position % 255 + 1;
        int temp = codeWord + random;
        if (temp <= 255) {
            return temp;
        }
        return temp - 256;
    }
}

