/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.datamatrixpmp;

import com.adobe.xfa.pmp.common.BarcodeEncoder;
import com.adobe.xfa.pmp.common.BarcodeGenerationParams;
import com.adobe.xfa.pmp.common.IntegerHolder;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixCompactorManager;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoderErrorCode;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoderException;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixImageBuilder;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixMatrix;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixMatrixBuilder;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixReedSolomon;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class DataMatrixEncoder
implements BarcodeEncoder {
    @Override
    public BufferedImage encode(char[] message, BarcodeGenerationParams pmpParams) throws DataMatrixEncoderException {
        double resolution = pmpParams.getResolution();
        if (resolution < 1.0) {
            throw new DataMatrixEncoderException(DataMatrixEncoderErrorCode.RESOLUTION);
        }
        int width = (int)(pmpParams.getWidth() * resolution + 0.5);
        int height = (int)(pmpParams.getHeight() * resolution + 0.5);
        int xSymWidth = pmpParams.getXSymbolWidth();
        if (xSymWidth < 1) {
            throw new DataMatrixEncoderException(DataMatrixEncoderErrorCode.XSYMWIDTH);
        }
        ArrayList<Integer> codeWords = new ArrayList<Integer>();
        IntegerHolder symbolSize = new IntegerHolder(-1);
        DataMatrixCompactorManager.compact(message, codeWords, symbolSize);
        DataMatrixReedSolomon.addECC(codeWords, symbolSize.getValue());
        DataMatrixMatrix matrix = DataMatrixMatrixBuilder.buildMatrix(codeWords, symbolSize.getValue());
        BufferedImage image = DataMatrixImageBuilder.buildImage(matrix, width, height, xSymWidth);
        return image;
    }
}

