/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.LcTime;
import java.util.Calendar;
import java.util.TimeZone;

public final class ISOTime
extends LcTime {
    public ISOTime() {
        super("en_US");
    }

    public ISOTime(int millis) {
        super(millis, "en_US");
    }

    public ISOTime(String locale, int centurySplit) {
        super(locale);
    }

    public ISOTime(String time, String locale) {
        super(locale);
        this.setTimeSymbols(this.mLocale.getIsoName());
        String trimTime = time;
        int tee = time.indexOf(84);
        if (tee >= 0) {
            trimTime = time.substring(tee + 1);
        }
        trimTime = trimTime.trim();
        this.setTimeSymbols("en_US");
        if (this.parse(trimTime)) {
            if (!this.mTimeZoneSeen) {
                Calendar now = Calendar.getInstance();
                this.mTimeZone = -now.get(15);
                if (TimeZone.getDefault().inDaylightTime(now.getTime())) {
                    this.mTimeZone -= now.get(16);
                }
            }
            this.mMillis = ISOTime.epoch(this.mHourOfDay, this.mMinuteOfHour, this.mSecondOfMinute, this.mThousandthOfSecond, this.mTimeZone);
            this.mAdjustment = 0;
            this.mValid = true;
        } else {
            this.mMillis = 0;
            this.mValid = false;
        }
        this.setTimeSymbols(this.mLocale.getIsoName());
    }

    boolean parse(String src) {
        boolean needColons = src.indexOf(58) >= 0;
        int srcPos = 0;
        int srcLen = src.length();
        this.mThousandthOfSecond = -1;
        this.mSecondOfMinute = -1;
        this.mMinuteOfHour = -1;
        this.mHourOfDay = -1;
        this.mTimeZone = -1;
        this.mMeriDiem = -1;
        this.mHourOfMeriDiem = -1;
        this.mTimeZoneSeen = false;
        if (srcPos + 2 > srcLen) {
            return false;
        }
        int parseRes = this.subParse(src, srcPos, 'H', 2);
        if (parseRes < 0) {
            return false;
        }
        srcPos = parseRes;
        if (srcPos == srcLen) {
            this.mMinuteOfHour = 0;
            this.mSecondOfMinute = 0;
            this.mThousandthOfSecond = 0;
            return true;
        }
        if (needColons) {
            if (!DateTimeUtil.matchChr(src, srcPos, ':', false)) {
                return false;
            }
            ++srcPos;
        }
        if (srcPos + 2 > srcLen) {
            return false;
        }
        parseRes = this.subParse(src, srcPos, 'M', 2);
        if (parseRes < 0) {
            return false;
        }
        srcPos = parseRes;
        if (srcPos == srcLen) {
            this.mSecondOfMinute = 0;
            this.mThousandthOfSecond = 0;
            return true;
        }
        if (needColons) {
            if (!DateTimeUtil.matchChr(src, srcPos, ':', false)) {
                return false;
            }
            ++srcPos;
        }
        if (srcPos + 2 > srcLen) {
            return false;
        }
        parseRes = this.subParse(src, srcPos, 'S', 2);
        if (parseRes < 0) {
            return false;
        }
        srcPos = parseRes;
        if (srcPos == srcLen) {
            this.mThousandthOfSecond = 0;
            return true;
        }
        if (DateTimeUtil.matchChr(src, srcPos, '.', false)) {
            if (++srcPos + 3 > srcLen) {
                return false;
            }
            parseRes = this.subParse(src, srcPos, 'F', 3);
            if (parseRes < 0) {
                return false;
            }
            srcPos = parseRes;
            if (srcPos == srcLen) {
                return true;
            }
        }
        if ((parseRes = this.subParse(src, srcPos, 'z', needColons ? 2 : 1)) < 0) {
            return false;
        }
        srcPos = parseRes;
        if (srcPos != srcLen) {
            return false;
        }
        if (this.mThousandthOfSecond == -1) {
            this.mThousandthOfSecond = 0;
        }
        return true;
    }
}

