/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public final class Numeric {
    private static final int MAX_PRECISION = 15;
    private static final NumberFormat format = NumberFormat.getNumberInstance(Locale.US);

    private Numeric() {
    }

    public static String doubleToStringUsingBigDecimal(double dValue, int fracDigits, boolean bTruncate) {
        if (Double.isNaN(dValue) || Double.isInfinite(dValue)) {
            return "";
        }
        if (fracDigits >= 0) {
            double fraction;
            int checkDigit;
            if (fracDigits > 15) {
                fracDigits = 15;
            }
            if ((checkDigit = (int)((fraction = dValue - (double)((int)dValue)) * Math.pow(10.0, fracDigits + 1)) - (int)(fraction * Math.pow(10.0, fracDigits)) * 10) == 5) {
                dValue += Math.pow(0.1, fracDigits + 1);
            }
            double p = Math.pow(10.0, fracDigits);
            String conversionString = "%#." + fracDigits + "f";
            if (fracDigits == 0) {
                conversionString = "%.0f";
            }
            String sValue = String.format(conversionString, new BigDecimal(dValue));
            if (!bTruncate) {
                return sValue;
            }
            if (sValue.charAt(sValue.length() - 1) != '0') {
                return sValue;
            }
            int endIndex = sValue.length() - 1;
            while (sValue.charAt(endIndex) == '0') {
                --endIndex;
            }
            if (sValue.charAt(endIndex) == '.') {
                --endIndex;
            }
            return sValue.substring(0, endIndex + 1);
        }
        String sValue = Numeric.getNumberFormat(fracDigits).format(dValue);
        return sValue;
    }

    public static String doubleToString(double dValue, int fracDigits, boolean bTruncate) {
        if (Double.isNaN(dValue) || Double.isInfinite(dValue)) {
            return "";
        }
        if (fracDigits >= 0) {
            double fraction;
            int checkDigit;
            if (fracDigits > 15) {
                fracDigits = 15;
            }
            if ((checkDigit = (int)((fraction = dValue - (double)((int)dValue)) * Math.pow(10.0, fracDigits + 1)) - (int)(fraction * Math.pow(10.0, fracDigits)) * 10) == 5) {
                dValue += Math.pow(0.1, fracDigits + 1);
            }
            double p = Math.pow(10.0, fracDigits);
            String conversionString = "%#." + fracDigits + "f";
            if (fracDigits == 0) {
                conversionString = "%.0f";
            }
            String sValue = String.format(conversionString, dValue);
            if (!bTruncate) {
                return sValue;
            }
            if (sValue.charAt(sValue.length() - 1) != '0') {
                return sValue;
            }
            int endIndex = sValue.length() - 1;
            while (sValue.charAt(endIndex) == '0') {
                --endIndex;
            }
            if (sValue.charAt(endIndex) == '.') {
                --endIndex;
            }
            return sValue.substring(0, endIndex + 1);
        }
        String sValue = Numeric.getNumberFormat(fracDigits).format(dValue);
        return sValue;
    }

    public static double stringToDouble(String str, boolean bAllowNaN) {
        if ((str = str.trim()).length() == 0) {
            return bAllowNaN ? Double.NaN : 0.0;
        }
        ParsePosition pp = new ParsePosition(0);
        Number n = Numeric.getNumberFormat(1).parse(str, pp);
        if (n == null || pp.getErrorIndex() != -1 || pp.getIndex() < str.length()) {
            return bAllowNaN ? Double.NaN : 0.0;
        }
        double d = n.doubleValue();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return bAllowNaN ? Double.NaN : 0.0;
        }
        return d;
    }

    private static NumberFormat getNumberFormat(int fracDigits) {
        NumberFormat customFormat = (NumberFormat)format.clone();
        customFormat.setMinimumFractionDigits(fracDigits);
        customFormat.setMaximumFractionDigits(fracDigits);
        return customFormat;
    }

    static {
        format.setGroupingUsed(false);
        format.setMinimumIntegerDigits(1);
        format.setMaximumIntegerDigits(310);
    }
}

