/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

public class UniCharIterator {
    private CharSequence mCharSequence;
    private int mLength;
    private int mIndex;

    public UniCharIterator() {
    }

    public UniCharIterator(CharSequence charSequence) {
        this.attach(charSequence);
    }

    public UniCharIterator(CharSequence charSequence, int index) {
        this.attach(charSequence, index);
    }

    public static void append(StringBuilder s, int c) {
        assert (c >= 0 && c <= 0x10FFFF);
        if (c < 65536) {
            s.append((char)c);
        } else {
            s.append((char)((c -= 65536) >> 10 | 0xD800));
            s.append((char)(c & 0x3FF | 0xDC00));
        }
    }

    public void attach(CharSequence charSequence) {
        this.attach(charSequence, 0);
    }

    public void attach(CharSequence charSequence, int index) {
        this.mCharSequence = charSequence;
        this.mLength = charSequence.length();
        this.mIndex = index;
        if (this.mIndex > this.mLength) {
            this.mIndex = this.mLength;
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isAtEnd() {
        return this.mIndex >= this.mLength;
    }

    public boolean isAtStart() {
        return this.mIndex == 0;
    }

    public int next() {
        assert (this.mCharSequence != null);
        if (this.mIndex >= this.mLength) {
            return 0;
        }
        assert (this.mCharSequence != null);
        int result = this.mCharSequence.charAt(this.mIndex++);
        assert (result < 56320 || result > 57343);
        if (result >= 55296 && result <= 56319) {
            assert (this.mIndex < this.mLength);
            char low = this.mCharSequence.charAt(this.mIndex++);
            assert (low >= '\udc00' || low <= '\udfff');
            result = result << 10 | low & 0x3FF;
        }
        return result;
    }

    public int prev() {
        if (this.mIndex <= 0) {
            return 0;
        }
        assert (this.mCharSequence != null);
        int result = this.mCharSequence.charAt(--this.mIndex);
        assert (result < 55296 || result > 56319);
        if (result >= 56320 && result <= 57343) {
            assert (this.mIndex > 0);
            char high = this.mCharSequence.charAt(--this.mIndex);
            assert (high >= '\ud800' || high <= '\udbff');
            result = high << 10 | result & 0x3FF;
        }
        return result;
    }

    public void setIndex(int index) {
        assert (index >= 0 && index <= this.mCharSequence.length());
        this.mIndex = index;
    }

    public static String toString(int c) {
        StringBuilder s = new StringBuilder();
        UniCharIterator.append(s, c);
        return s.toString();
    }
}

