/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut.lcdata;

public final class LcBundle {
    public static final String BUNDLE_BASE = "com/adobe/xfa/ut/lcdata/Locale";
    private static final String[] LONG_MONTH_PROPERTIES = new String[]{"gregorian.month.full.jan", "gregorian.month.full.feb", "gregorian.month.full.mar", "gregorian.month.full.apr", "gregorian.month.full.may", "gregorian.month.full.jun", "gregorian.month.full.jul", "gregorian.month.full.aug", "gregorian.month.full.sep", "gregorian.month.full.oct", "gregorian.month.full.nov", "gregorian.month.full.dec"};
    private static final String[] SHORT_MONTH_PROPERTIES = new String[]{"gregorian.month.abbr.jan", "gregorian.month.abbr.feb", "gregorian.month.abbr.mar", "gregorian.month.abbr.apr", "gregorian.month.abbr.may", "gregorian.month.abbr.jun", "gregorian.month.abbr.jul", "gregorian.month.abbr.aug", "gregorian.month.abbr.sep", "gregorian.month.abbr.oct", "gregorian.month.abbr.nov", "gregorian.month.abbr.dec"};
    private static final String[] LONG_WEEKDAY_PROPERTIES = new String[]{"gregorian.weekday.full.sun", "gregorian.weekday.full.mon", "gregorian.weekday.full.tue", "gregorian.weekday.full.wed", "gregorian.weekday.full.thu", "gregorian.weekday.full.fri", "gregorian.weekday.full.sat"};
    private static final String[] SHORT_WEEKDAY_PROPERTIES = new String[]{"gregorian.weekday.abbr.sun", "gregorian.weekday.abbr.mon", "gregorian.weekday.abbr.tue", "gregorian.weekday.abbr.wed", "gregorian.weekday.abbr.thu", "gregorian.weekday.abbr.fri", "gregorian.weekday.abbr.sat"};
    private static final String[] MERIDIEM_PROPERTIES = new String[]{"gregorian.meridiem.am", "gregorian.meridiem.pm"};
    private static final String[] ERA_PROPERTIES = new String[]{"gregorian.era.bc", "gregorian.era.ad"};
    private static final String[] DATE_PATTERN_PROPERTIES = new String[]{"gregorian.date.pattern.full", "gregorian.date.pattern.long", "gregorian.date.pattern.medium", "gregorian.date.pattern.short"};
    private static final String[] TIME_PATTERN_PROPERTIES = new String[]{"gregorian.time.pattern.full", "gregorian.time.pattern.long", "gregorian.time.pattern.medium", "gregorian.time.pattern.short"};
    private static final String[] NUMBER_PATTERN_PROPERTIES = new String[]{"number.pattern.numeric", "number.pattern.currency", "number.pattern.percent"};
    private static final String[] NUMERIC_SYMBOL_PROPERTIES = new String[]{"numeric.symbol.decimal", "numeric.symbol.grouping", "numeric.symbol.percent", "numeric.symbol.minus", "numeric.symbol.zero"};
    private static final String[] CURRENCY_SYMBOL_PROPERTIES = new String[]{"currency.symbol.sym", "currency.symbol.name", "currency.symbol.decimal"};

    private LcBundle() {
    }

    public static String getLongMonthProperty(int month) {
        return LONG_MONTH_PROPERTIES[month];
    }

    public static String getShortMonthProperty(int month) {
        return SHORT_MONTH_PROPERTIES[month];
    }

    public static String getLongDayProperty(int weekday) {
        return LONG_WEEKDAY_PROPERTIES[weekday];
    }

    public static String getShortDayProperty(int weekday) {
        return SHORT_WEEKDAY_PROPERTIES[weekday];
    }

    public static String getMeridiemProperty(int aspect) {
        return MERIDIEM_PROPERTIES[aspect];
    }

    public static String getEraProperty(int era) {
        return ERA_PROPERTIES[era];
    }

    public static String getDateFormatProperty(int style) {
        return DATE_PATTERN_PROPERTIES[style];
    }

    public static String getTimeFormatProperty(int style) {
        return TIME_PATTERN_PROPERTIES[style];
    }

    public static String getDateTimeFormatProperty() {
        return "gregorian.datetime.pattern";
    }

    public static String getDateTimeSymbolsProperty() {
        return "gregorian.datetime.symbols";
    }

    public static String getNumberFormatProperty(int style) {
        return NUMBER_PATTERN_PROPERTIES[style];
    }

    public static String getNumericSymbolProperty(int symbol) {
        return NUMERIC_SYMBOL_PROPERTIES[symbol];
    }

    public static String getCurrencySymbolProperty(int symbol) {
        return CURRENCY_SYMBOL_PROPERTIES[symbol];
    }

    public static String getTypefacesProperty() {
        return "font.typefaces";
    }
}

