/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.wspolicy;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.dom.DOM;
import com.adobe.xfa.dom.NamespaceContextImpl;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.wspolicy.CompoundAssertion;
import com.adobe.xfa.wspolicy.PrimitiveAssertion;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class Policy
extends Element {
    public static final String aWSP_NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String aWSP_NAMESPACE_PREFIX = "wsp";
    public static final String aWSP_POLICYURIS = "PolicyURIs";
    public static final String aWSP_POLICY = "Policy";
    public static final String aWSP_POLICYREFERENCE = "PolicyReference";
    public static final String aWSP_URIATTR = "URI";
    public static final String aWSP_ALL = "All";
    public static final String aWSP_EXACTLYONE = "ExactlyOne";
    public static final String aSP_NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    public static final String aSP_NAMESPACE_PREFIX = "sp";
    public static final String aSP_TRANSPORTBINDING = "TransportBinding";
    public static final String aSP_TRANSPORTTOKEN = "TransportToken";
    public static final String aSP_HTTPSTOKEN = "HttpsToken";
    public static final String aSP_HTTPBASICAUTHENTICATION = "HttpBasicAuthentication";
    public static final String aSP_HTTPDIGESTAUTHENTICATION = "HttpDigestAuthentication";
    public static final String aSP_REQUIRECLIENTCERTIFICATE = "RequireClientCertificate";
    public static final String aSP_USERNAMETOKEN = "UsernameToken";
    public static final String aSP_HASHPASSWORD = "HashPassword";
    public static final String aSP_X509TOKEN = "X509Token";
    public static final String aSP_SUPPORTINGTOKENS = "SupportingTokens";
    public static final String aWSU_NAMESPACE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wsswssecurity-utility-1.0.xsd";
    public static final String aWSU_NAMESPACE_PREFIX = "wsu";
    public static final String aWSU_ID = "Id";
    public static final int WSP_PRIMITIVE_ASSERTION = 0;
    public static final int WSP_ALL_ASSERTION = 1;
    public static final int WSP_EXACTLY_ONE_ASSERTION = 2;
    private static XPathFactory mXPathFactory;
    private Element moDomNode;
    private int meAssertionType;
    private org.w3c.dom.Document mShadowDoc;
    private org.w3c.dom.Node mShadowNode;

    public final Policy getFirstPolicyChild() {
        return Policy.getNextPolicySibling(this.getFirstXMLChild());
    }

    public final Policy getNextPolicySibling() {
        return Policy.getNextPolicySibling(this.getNextXMLSibling());
    }

    public static CompoundAssertion resolvePolicy(Element oHostNode) {
        CompoundAssertion poPolicy;
        AppModel appModel = new AppModel(null);
        Document oDestDoc = appModel.getDocument();
        oDestDoc.declareGlobalXMLId(aWSU_NAMESPACE_URI, aWSU_ID);
        CompoundAssertion poMerged = null;
        String sPolicyURIs = null;
        int attrIndex = oHostNode.findAttr(aWSP_NAMESPACE_URI, aWSP_POLICYURIS);
        if (attrIndex >= 0) {
            sPolicyURIs = oHostNode.getAttrVal(attrIndex);
        }
        if (!StringUtils.isEmpty(sPolicyURIs)) {
            StringBuilder uriTokenizer = new StringBuilder(sPolicyURIs);
            String sURI = StringUtils.parseToken(uriTokenizer);
            while (sURI != null) {
                poPolicy = Policy.loadPolicyByReference(oDestDoc, oHostNode.getOwnerDocument(), sURI);
                poMerged = poPolicy != null && poMerged != null ? Policy.mergePolicies(poMerged, poPolicy) : poPolicy;
                sURI = StringUtils.parseToken(uriTokenizer);
            }
        }
        for (Node oChild = oHostNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            Element e;
            if (!(oChild instanceof Element) || !Policy.isPolicyOrRef(e = (Element)oChild)) continue;
            poPolicy = (CompoundAssertion)Policy.loadPolicy(oDestDoc, e);
            poMerged = poPolicy != null && poMerged != null ? Policy.mergePolicies(poMerged, poPolicy) : poPolicy;
        }
        if (poMerged != null) {
            CompoundAssertion policy = poMerged;
            oDestDoc.appendChild(policy.moDomNode);
        }
        return poMerged;
    }

    public static void deletePolicyInfo(Element oHostNode) {
        String policyURIsAttr = null;
        int attrIndex = oHostNode.findAttr(aWSP_NAMESPACE_URI, aWSP_POLICYURIS);
        if (attrIndex >= 0 && !StringUtils.isEmpty(policyURIsAttr = oHostNode.getAttrVal(attrIndex))) {
            oHostNode.removeAttr(attrIndex);
        }
        for (Node oChild = oHostNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            if (!(oChild instanceof Element) || !Policy.isPolicyOrRef((Element)oChild)) continue;
            oHostNode.removeChild(oChild);
        }
    }

    static Policy loadPolicy(Document oDestDoc, Element oSrc) {
        String aNameSpaceURI = oSrc.getNS();
        String aLocalName = oSrc.getLocalName();
        Policy result = null;
        if (aNameSpaceURI == aWSP_NAMESPACE_URI && aLocalName == aWSP_POLICYREFERENCE) {
            String uriAttr;
            int attrIndex = oSrc.findAttr(aWSP_NAMESPACE_URI, aWSP_URIATTR);
            if (attrIndex >= 0 && !StringUtils.isEmpty(uriAttr = oSrc.getAttrVal(attrIndex))) {
                result = Policy.loadPolicyByReference(oDestDoc, oSrc.getOwnerDocument(), uriAttr);
            }
        } else {
            result = aNameSpaceURI == aWSP_NAMESPACE_URI && aLocalName == aWSP_POLICY ? new CompoundAssertion(oDestDoc, oSrc, 1) : (aNameSpaceURI == aWSP_NAMESPACE_URI && aLocalName == aWSP_POLICYREFERENCE ? new CompoundAssertion(oDestDoc, oSrc, 1) : (aNameSpaceURI == aWSP_NAMESPACE_URI && aLocalName == aWSP_ALL ? new CompoundAssertion(oDestDoc, oSrc, 1) : (aNameSpaceURI == aWSP_NAMESPACE_URI && aLocalName == aWSP_EXACTLYONE ? new CompoundAssertion(oDestDoc, oSrc, 2) : new PrimitiveAssertion(oDestDoc, oSrc))));
        }
        return result;
    }

    public static CompoundAssertion newPolicy(Document oDestDoc, ObjectHolder<Element> oNewDomNodeOut) {
        CompoundAssertion poPolicy = new CompoundAssertion(oDestDoc, aWSP_NAMESPACE_URI, aWSP_POLICY);
        if (oNewDomNodeOut != null) {
            oNewDomNodeOut.value = poPolicy.getDomNode();
        }
        return poPolicy;
    }

    public int getAssertionType() {
        return this.meAssertionType;
    }

    private static CompoundAssertion loadPolicyByReference(Document oDestDoc, Document oSrcDoc, String sURI) {
        String sID;
        Element oSrc;
        if (sURI.length() > 0 && sURI.charAt(0) == '#' && (oSrc = oSrcDoc.getElementByXMLId(sID = sURI.substring(1))) != null) {
            return new CompoundAssertion(oDestDoc, oSrc, 1);
        }
        return null;
    }

    private static CompoundAssertion mergePolicies(Policy poLeft, Policy poRight) {
        String sPrefix = poLeft.getDomNode().getPrefix();
        String sLocal = aWSP_ALL;
        String aQName = (sPrefix + ':' + sLocal).intern();
        poLeft.getDomNode().setQName(aQName);
        poRight.getDomNode().setQName(aQName);
        Document oDestDoc = poLeft.getDomNode().getOwnerDocument();
        CompoundAssertion poMerged = new CompoundAssertion(oDestDoc, aWSP_NAMESPACE_URI, aWSP_POLICY);
        poMerged.addPolicy(poLeft);
        poMerged.addPolicy(poRight);
        return poMerged;
    }

    public String getProperty(String sXPath) {
        org.w3c.dom.Node shadowNode = this.getShadowNode();
        XPath xpath = Policy.getXPathFactory().newXPath();
        NamespaceContextImpl namespaceContext = new NamespaceContextImpl(shadowNode);
        namespaceContext.addNamespaceMapping(aWSP_NAMESPACE_PREFIX, aWSP_NAMESPACE_URI);
        namespaceContext.addNamespaceMapping(aSP_NAMESPACE_PREFIX, aSP_NAMESPACE_URI);
        namespaceContext.addNamespaceMapping(aWSU_NAMESPACE_PREFIX, aWSU_NAMESPACE_URI);
        xpath.setNamespaceContext(namespaceContext);
        try {
            return xpath.evaluate(sXPath, shadowNode);
        }
        catch (XPathExpressionException e) {
            throw new ExFull(ResId.XPATH_ERROR, e.getMessage());
        }
    }

    public Policy getParentPolicy() {
        Element parent = this.getXMLParent();
        if (parent == null) {
            return null;
        }
        assert (parent instanceof Policy);
        return (Policy)parent;
    }

    void addPolicy(Policy poPolicy) {
        this.moDomNode.appendChild(poPolicy.getDomNode());
        this.appendChild(poPolicy);
    }

    private org.w3c.dom.Node getShadowNode() {
        if (this.mShadowNode == null) {
            org.w3c.dom.Document shadowDoc = this.getShadowDocument(this.moDomNode);
            this.mShadowNode = DOM.attach(shadowDoc, this.moDomNode);
        }
        return this.mShadowNode;
    }

    private static XPathFactory getXPathFactory() {
        if (mXPathFactory == null) {
            mXPathFactory = XPathFactory.newInstance();
        }
        return mXPathFactory;
    }

    static final boolean isPolicyOrRef(Element e) {
        String localName = e.getLocalName();
        return e.getNS() == aWSP_NAMESPACE_URI && (localName == aWSP_POLICY || localName == aWSP_POLICYREFERENCE);
    }

    protected Policy(Document oDestDoc, Element oSrcNode) {
        this.init(oDestDoc, (Element)oDestDoc.importNode(oSrcNode, false));
    }

    protected Policy(Document oDestDoc, String aNameSpaceURI, String aLocalName) {
        String sPrefix = "";
        if (aNameSpaceURI == aWSP_NAMESPACE_URI) {
            sPrefix = "wsp:";
        } else if (aNameSpaceURI == aSP_NAMESPACE_URI) {
            sPrefix = "sp:";
        }
        this.init(oDestDoc, oDestDoc.createElementNS(aNameSpaceURI, sPrefix + aLocalName, null));
    }

    protected final void setAssertionType(int eAssertionType) {
        this.meAssertionType = eAssertionType;
    }

    protected final Element getDomNode() {
        return this.moDomNode;
    }

    private void init(Document doc, Element clonedNode) {
        this.moDomNode = clonedNode;
        this.moDomNode.setModel(doc.getModel());
        this.setNameSpaceURI(this.moDomNode.getNS(), true, false, false);
        this.setLocalName(this.moDomNode.getLocalName());
        this.meAssertionType = 0;
    }

    private static Policy getNextPolicySibling(Node node) {
        while (node != null) {
            if (node instanceof Policy) {
                return (Policy)node;
            }
            node = node.getNextXMLSibling();
        }
        return null;
    }

    private org.w3c.dom.Document getShadowDocument(Node domNode) {
        if (this.mShadowDoc == null) {
            Policy parentPolicy = this.getParentPolicy();
            if (parentPolicy != null) {
                this.mShadowDoc = parentPolicy.getShadowDocument(domNode);
            } else {
                org.w3c.dom.Node shadowNode = DOM.attach(this.moDomNode);
                this.mShadowDoc = shadowNode.getOwnerDocument();
            }
        }
        return this.mShadowDoc;
    }
}

