/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.path;

import com.adobe.xmp.path.XMPPathParser;
import com.adobe.xmp.path.XMPPathParserException;
import com.adobe.xmp.path.XMPPathSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class XMPPath
implements List<XMPPathSegment> {
    private List<XMPPathSegment> segments = new ArrayList<XMPPathSegment>();

    public static XMPPath parse(String path, Map<String, String> prefixContract) throws XMPPathParserException {
        return XMPPathParser.parse(path, prefixContract);
    }

    public String serialize() {
        return this.serialize(null);
    }

    public String serialize(Map<String, String> prefixContract) {
        StringBuffer result = new StringBuffer();
        boolean firstSegment = true;
        for (XMPPathSegment segment : this.segments) {
            String prefix = null;
            if (prefixContract != null) {
                for (Map.Entry<String, String> entry : prefixContract.entrySet()) {
                    if (!entry.getValue().equals(segment.getNamespace())) continue;
                    prefix = entry.getKey();
                }
            }
            if (prefix == null) {
                prefix = segment.getNamespace();
            }
            switch (segment.getType()) {
                case PROPERTY: {
                    if (!firstSegment) {
                        result.append("/");
                    }
                    result.append(prefix + ":" + segment.getName());
                    break;
                }
                case ARRAY_INDEX: {
                    result.append("[" + segment.getIndex() + "]");
                    break;
                }
                case QUALIFIER: {
                    if (!firstSegment) {
                        result.append("/");
                    }
                    result.append("@" + prefix + ":" + segment.getName());
                    break;
                }
                case QUALIFIER_SELECTOR: {
                    result.append("[?" + prefix + ":" + segment.getName() + "=\"" + segment.getValue() + "\"]");
                }
            }
            if (!firstSegment) continue;
            firstSegment = false;
        }
        return result.toString();
    }

    @Override
    public int size() {
        return this.segments.size();
    }

    @Override
    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.segments.contains(o);
    }

    @Override
    public Iterator<XMPPathSegment> iterator() {
        return this.segments.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.segments.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.segments.toArray(a);
    }

    @Override
    public boolean add(XMPPathSegment e) {
        return this.segments.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.segments.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.segments.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends XMPPathSegment> c) {
        return this.segments.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends XMPPathSegment> c) {
        return this.segments.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.segments.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.segments.retainAll(c);
    }

    @Override
    public void clear() {
        this.segments.clear();
    }

    @Override
    public XMPPathSegment get(int index) {
        return this.segments.get(index);
    }

    @Override
    public XMPPathSegment set(int index, XMPPathSegment element) {
        return this.segments.set(index, element);
    }

    @Override
    public void add(int index, XMPPathSegment element) {
        this.segments.add(index, element);
    }

    @Override
    public XMPPathSegment remove(int index) {
        return this.segments.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.segments.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.segments.lastIndexOf(o);
    }

    @Override
    public ListIterator<XMPPathSegment> listIterator() {
        return this.segments.listIterator();
    }

    @Override
    public ListIterator<XMPPathSegment> listIterator(int index) {
        return this.segments.listIterator(index);
    }

    @Override
    public List<XMPPathSegment> subList(int fromIndex, int toIndex) {
        return this.segments.subList(fromIndex, toIndex);
    }

    public Compare compare(XMPPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (this.size() == 0 && path.size() == 0) {
            return Compare.EQUAL;
        }
        if (this.size() == 0 && path.size() != 0 || this.size() != 0 && path.size() == 0) {
            return Compare.DIFFERENT;
        }
        ListIterator<XMPPathSegment> pathIter = this.listIterator();
        ListIterator<XMPPathSegment> otherPathIter = path.listIterator();
        while (pathIter.hasNext()) {
            if (otherPathIter.hasNext()) {
                if (pathIter.next().equals(otherPathIter.next())) continue;
                return Compare.DIFFERENT;
            }
            return Compare.DESCENDANT;
        }
        if (otherPathIter.hasNext()) {
            return Compare.ANCESTOR;
        }
        return Compare.EQUAL;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMPPath other = (XMPPath)obj;
        return !(this.segments == null ? other.segments != null : !this.segments.equals(other.segments));
    }

    public static enum Compare {
        DIFFERENT,
        EQUAL,
        ANCESTOR,
        DESCENDANT;

    }
}

