/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.SimpleType;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;
import com.adobe.xmp.schema.model.rules.Vocable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosedChoice
implements TypeRule {
    private static final long serialVersionUID = 1L;
    private ArrayList<Vocable> vocabulary = new ArrayList();
    private Vocable.Type vocablularyType;

    public ClosedChoice(Vocable.Type vocablularyType) {
        this.vocablularyType = vocablularyType;
    }

    public void addVocable(Object xmpValue, String label) throws XMPSchemaException {
        this.checkType(xmpValue);
        this.vocabulary.add(new Vocable(xmpValue, label));
    }

    public void addVocable(Vocable vocable) throws XMPSchemaException {
        this.checkType(vocable.getXmpValue());
        this.vocabulary.add(vocable);
    }

    public List<Vocable> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException {
        schemaVisitor.visit(this);
    }

    private void checkType(Object xmpValue) throws XMPSchemaException {
        switch (this.vocablularyType) {
            case TEXT: {
                if (xmpValue instanceof String) break;
                throw new XMPSchemaException("Vocable has to be of type '" + SimpleType.BasicType.TEXT.toString() + "'");
            }
            case INTEGER: {
                if (xmpValue instanceof Integer || xmpValue instanceof Long) break;
                throw new XMPSchemaException("Vocable has to be of type '" + SimpleType.BasicType.INTEGER.toString() + "' (Integer in Java)");
            }
            case REAL: {
                if (xmpValue instanceof Float || xmpValue instanceof Double) break;
                throw new XMPSchemaException("Vocable has to be of type '" + SimpleType.BasicType.REAL.toString() + "' (Double in Java)");
            }
            case BOOLEAN: {
                if (xmpValue instanceof Boolean) break;
                throw new XMPSchemaException("Vocable has to be of type '" + SimpleType.BasicType.BOOLEAN.toString() + "' (Boolean in Java)");
            }
            case DATE: {
                if (xmpValue instanceof String) break;
                throw new XMPSchemaException("Vocable has to be of type '" + SimpleType.BasicType.DATE.toString() + "' (a String in ISO8601 format in Java)");
            }
            case ARRAY_OF_INTEGER: {
                if (xmpValue instanceof Integer[] || xmpValue instanceof int[]) break;
                throw new XMPSchemaException("Vocable has to an array of integer, ie. Integer[] or int[] in java)");
            }
        }
    }
}

