/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.rng.model;

import com.adobe.xmp.schema.rng.model.ParamInfo;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamInfoGroup
implements ParamInfo {
    private Stack<ParamInfo> mParamInfos;
    private final Operator mOperator;
    private boolean isChoice;

    public ParamInfoGroup(Operator operator2) {
        this.mOperator = operator2;
        this.mParamInfos = new Stack();
    }

    public Operator getOperator() {
        return this.mOperator;
    }

    public void push(ParamInfo info) {
        ParamInfoGroup group;
        boolean exists = false;
        ParamInfo newInfo = info;
        if (info instanceof ParamInfoGroup && (group = (ParamInfoGroup)info).size() == 1) {
            newInfo = group.pop();
        }
        for (ParamInfo param : this.mParamInfos) {
            exists |= param.equals(newInfo);
        }
        if (!exists) {
            this.mParamInfos.push(newInfo);
        }
    }

    ParamInfo pop() {
        return this.mParamInfos.pop();
    }

    public boolean empty() {
        return this.mParamInfos.empty();
    }

    int size() {
        return this.mParamInfos.size();
    }

    public Stack<ParamInfo> getParams() {
        return this.mParamInfos;
    }

    @Override
    public boolean equals(ParamInfo param) {
        boolean ret = false;
        if (param instanceof ParamInfoGroup) {
            ParamInfoGroup group = (ParamInfoGroup)param;
            if (this.size() == group.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    ret |= ((ParamInfo)this.mParamInfos.get(i)).equals((ParamInfo)group.mParamInfos.get(i));
                }
            }
        }
        return ret;
    }

    public void setChoice(boolean isChoice) {
        this.isChoice = isChoice;
    }

    public boolean isChoice() {
        return this.isChoice;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("========== ParamInfoGroup =========");
        str.append("\nOperator : ").append((Object)this.mOperator);
        if (this.mParamInfos != null) {
            for (ParamInfo param : this.mParamInfos) {
                str.append(param.toString());
            }
        }
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        kOR,
        kAND;

    }
}

