/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.analytics.sitecatalyst.AbstractApiAdapter;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.util.AnalyticsConfig;
import com.day.cq.analytics.sitecatalyst.util.TokenProviderProxy;
import com.day.cq.analytics.sitecatalyst.util.WebService;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImsApiAdapter
extends AbstractApiAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ImsApiAdapter.class);
    private static final String DEFAULT_ENDPOINT_URI = "https://analytics.adobe.io";
    private static final String SUPPORT_ENGINE = "oberon";
    private final WebService client;
    private final Configuration configuration = null;
    private final AnalyticsConfig analyticsConfig;

    public ImsApiAdapter(Map configuration, WebService client, TokenProviderProxy tokenProviderProxy) {
        this.client = client;
        this.analyticsConfig = new AnalyticsConfig(configuration, tokenProviderProxy);
    }

    @Override
    protected AbstractApiAdapter.ApiKind getApiKind() {
        return AbstractApiAdapter.ApiKind.IMS;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    private URI buildURI(@Nonnull String uriStr, @Nullable Map<String, String> parameters) throws Exception {
        try {
            URI uri = new URI(uriStr);
            URIBuilder uriBuilder = new URIBuilder(uri);
            if (parameters != null) {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    uriBuilder.addParameter(parameter.getKey(), parameter.getValue());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(uriStr);
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            LOG.error("Unable to build URI", e);
            throw new Exception("Unable to build URI", e);
        }
    }

    @Override
    public String getSegments(Map params) throws SitecatalystException {
        try {
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/segments?includeType=all", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            JsonObject jsonResponse = (JsonObject)new JsonParser().parse(response);
            response = jsonResponse.get("content").toString();
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(response);
            }
            return response;
        }
        catch (Exception e) {
            LOG.error("Unable to get segments", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getReportSuites(Map params) throws SitecatalystException {
        try {
            params.put("limit", "1000");
            params.put("expansion", "enabledSolutions");
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/collections/suites", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            JsonObject jsonResponse = (JsonObject)new JsonParser().parse(response);
            JsonObject finalResponse = new JsonObject();
            finalResponse.add("report_suites", jsonResponse.get("content"));
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.getAsString());
            }
            return finalResponse.toString();
        }
        catch (Exception e) {
            LOG.error("Unable to get report suites", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public JsonObject getGlobalCompanyID(Map params) throws SitecatalystException {
        try {
            URI uri = this.buildURI("https://analytics.adobe.io/discovery/me", params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            JsonObject jsonResponse = (JsonObject)new JsonParser().parse(response);
            String globalCompanyID = ((JsonObject)((JsonArray)((JsonObject)((JsonArray)jsonResponse.get("imsOrgs")).get(0)).get("companies")).get(0)).get("globalCompanyId").getAsString();
            String CompanyID = ((JsonObject)((JsonArray)((JsonObject)((JsonArray)jsonResponse.get("imsOrgs")).get(0)).get("companies")).get(0)).get("companyName").getAsString();
            JsonObject finalResponse = new JsonObject();
            finalResponse.add("x-proxy-global-company-id", new JsonPrimitive(globalCompanyID));
            finalResponse.add("company", new JsonPrimitive(CompanyID));
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.getAsString());
            }
            return finalResponse;
        }
        catch (Exception e) {
            LOG.error("Unable to get global company ID", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getTrackingServer(Configuration configuration, Map params) throws SitecatalystException {
        try {
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/companies/me/trackingserver", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            JsonObject jsonResponse = (JsonObject)new JsonParser().parse(response);
            JsonObject finalResponse = new JsonObject();
            finalResponse.add("tracking_server", jsonResponse.get("trackingServer"));
            uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/companies/me", this.analyticsConfig.getCompanyId()), params);
            response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            jsonResponse = (JsonObject)new JsonParser().parse(response);
            finalResponse.add("namespace", jsonResponse.get("namespace"));
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.getAsString());
            }
            return finalResponse.toString();
        }
        catch (Exception e) {
            LOG.error("Unable to get tracking server", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getTrafficVars(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("x-proxy-global-company-id", configuration.getInherited("x-proxy-global-company-id", ""));
            params.put("rsid", rsid);
            params.put("support", SUPPORT_ENGINE);
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/dimensions", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            JsonArray jsonResponse = (JsonArray)new JsonParser().parse(response);
            JsonArray finalResponse = new JsonArray();
            JsonObject finalResponseObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (JsonElement item : jsonResponse) {
                if (!((JsonObject)item).has("extraTitleInfo") || !"Content".equals(((JsonObject)item).get("category").getAsString())) continue;
                JsonObject temp = new JsonObject();
                String id = ((JsonObject)item).get("id").getAsString();
                temp.add("id", new JsonPrimitive(id.substring(id.indexOf("/") + 1)));
                temp.add("name", ((JsonObject)item).get("name"));
                temp.add("enabled", new JsonPrimitive(true));
                jsonArray.add(temp);
            }
            finalResponseObject.add("props", jsonArray);
            finalResponse.add(finalResponseObject);
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.getAsString());
            }
            return finalResponse.toString();
        }
        catch (Exception e) {
            LOG.error("Unable to get traffic vars", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getEvars(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("x-proxy-global-company-id", configuration.getInherited("x-proxy-global-company-id", ""));
            params.put("rsid", rsid);
            params.put("support", SUPPORT_ENGINE);
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/dimensions", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            JsonArray jsonResponse = (JsonArray)new JsonParser().parse(response);
            JsonArray finalResponse = new JsonArray();
            JsonObject finalResponseObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (JsonElement item : jsonResponse) {
                if (!((JsonObject)item).has("extraTitleInfo") || !"Conversion".equals(((JsonObject)item).get("category").getAsString())) continue;
                JsonObject temp = new JsonObject();
                String id = ((JsonObject)item).get("id").getAsString();
                temp.add("id", new JsonPrimitive(id.substring(id.indexOf("/") + 1)));
                temp.add("name", ((JsonObject)item).get("name"));
                temp.add("enabled", new JsonPrimitive(true));
                temp.add("type", ((JsonObject)item).get("type"));
                jsonArray.add(temp);
            }
            finalResponseObject.add("evars", jsonArray);
            finalResponse.add(finalResponseObject);
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.getAsString());
            }
            return finalResponse.toString();
        }
        catch (Exception e) {
            LOG.error("Unable to get evars", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getSuccessEvents(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("x-proxy-global-company-id", configuration.getInherited("x-proxy-global-company-id", ""));
            params.put("rsid", rsid);
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/metrics", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            JsonArray jsonResponse = (JsonArray)new JsonParser().parse(response);
            JsonArray finalResponse = new JsonArray();
            JsonObject finalResponseObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (JsonElement item : jsonResponse) {
                JsonObject temp = new JsonObject();
                String id = ((JsonObject)item).get("id").getAsString();
                temp.add("id", new JsonPrimitive(id.substring(id.indexOf("/") + 1)));
                temp.add("name", ((JsonObject)item).get("name"));
                temp.add("type", ((JsonObject)item).get("type"));
                jsonArray.add(temp);
            }
            finalResponseObject.add("events", jsonArray);
            finalResponse.add(finalResponseObject);
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.getAsString());
            }
            return finalResponse.toString();
        }
        catch (Exception e) {
            LOG.error("Unable to get success events", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getMetrics(Configuration configuration, String rsid) throws SitecatalystException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("x-proxy-global-company-id", configuration.getInherited("x-proxy-global-company-id", ""));
            params.put("rsid", rsid);
            params.put("support", SUPPORT_ENGINE);
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/metrics", this.analyticsConfig.getCompanyId()), params);
            String response = this.client.request(new HttpGet(uri), this.analyticsConfig);
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(response);
            }
            return response;
        }
        catch (Exception e) {
            LOG.error("Unable to get metrics", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    @Override
    public String getReport(Configuration configuration, String data) throws Exception {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("x-proxy-global-company-id", configuration.getInherited("x-proxy-global-company-id", ""));
            String reportsuite = configuration.getInherited("reportsuite", null);
            params.put("rsid", reportsuite);
            URI uri = this.buildURI(DEFAULT_ENDPOINT_URI + String.format("/api/%s/reports", this.analyticsConfig.getCompanyId()), params);
            HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setContentEncoding("UTF-8").setText(data).build();
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity(entity);
            JsonObject jsonData = (JsonObject)new JsonParser().parse(data);
            String response = this.client.request(httpPost, this.analyticsConfig);
            String error = this.getError(response);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            JsonObject finalResponse = this.getJsonObject(reportsuite, jsonData, response);
            if (LOG.isDebugEnabled()) {
                LOG.debug(finalResponse.toString());
            }
            return finalResponse.toString();
        }
        catch (Exception e) {
            LOG.error("Unable to get report", e);
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    private JsonObject getJsonObject(String reportsuite, JsonObject jsonData, String response) {
        JsonObject jsonResponse = (JsonObject)new JsonParser().parse(response);
        JsonObject finalResponse = new JsonObject();
        finalResponse.add("reportSuite", new JsonParser().parse("{\n            \"id\": " + reportsuite + ",\n            \"name\": " + reportsuite + "\n        }"));
        finalResponse.add("elements", new JsonParser().parse("[{\n            \"id\": " + jsonData.get("dimension").getAsString().substring(jsonData.get("dimension").getAsString().indexOf("/") + 1) + ",\n            \"name\": " + jsonData.get("dimension").getAsString().substring(jsonData.get("dimension").getAsString().indexOf("/") + 1) + "\n        }]"));
        finalResponse.add("metrics", jsonData.get("metricContainer").getAsJsonObject().get("metrics").getAsJsonArray());
        int averagetimespentonsiteIndex = -1;
        for (int i = 0; i < finalResponse.get("metrics").getAsJsonArray().size(); ++i) {
            String id = finalResponse.get("metrics").getAsJsonArray().get(i).getAsJsonObject().get("id").getAsString();
            if ("averagetimespentonsite".equals(id = id.substring(id.indexOf("/") + 1))) {
                id = "averagetimespentonpage";
                averagetimespentonsiteIndex = i;
            }
            finalResponse.get("metrics").getAsJsonArray().get(i).getAsJsonObject().add("id", new JsonPrimitive(id));
        }
        finalResponse.add("totals", jsonResponse.get("summaryData").getAsJsonObject().get("totals").getAsJsonArray());
        JsonArray rowData = new JsonArray();
        for (JsonElement o : jsonResponse.get("rows").getAsJsonArray()) {
            JsonObject temp = o.getAsJsonObject();
            temp.add("name", temp.get("value"));
            JsonArray countData = temp.getAsJsonArray("data");
            if (averagetimespentonsiteIndex != -1) {
                countData.set(averagetimespentonsiteIndex, new JsonPrimitive(countData.get(averagetimespentonsiteIndex).getAsDouble() / 60.0));
            }
            temp.add("counts", countData);
            rowData.add(temp);
        }
        finalResponse.add("data", rowData);
        finalResponse.add("type", new JsonPrimitive("ranked"));
        return finalResponse;
    }
}

