/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.workspaces;

import com.adobe.cq.adobeims.imsprofile.ImsProfileProdCtx;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Workspace {
    private final String id;
    private final String name;

    public Workspace(@Nonnull ImsProfileProdCtx imsProfile) {
        this.id = imsProfile.getGroupId();
        this.name = imsProfile.getUserVisibleName();
    }

    public Workspace(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return this.id.equals(workspace.id) && this.name.equals(workspace.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return "Workspace{id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

