/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.feed;

import com.day.cq.commons.SimpleXml;
import com.day.cq.commons.feed.Feed;
import com.day.cq.commons.feed.StringResponseWrapper;
import com.day.text.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.SimpleTimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeed
implements Feed {
    final Logger log = LoggerFactory.getLogger(Feed.class);
    static final String[] textNodes = new String[3];
    SimpleXml xml;
    SlingHttpServletRequest request;
    SlingHttpServletResponse response;
    String title;
    String description;
    String tags;
    String language;
    String author;
    String publishedDate;
    String nodePath;
    String baseUrl;
    long fileSize;
    String mimeType;

    public AbstractFeed(Resource res, SlingHttpServletRequest req, SlingHttpServletResponse resp) throws RepositoryException {
        this.request = req;
        this.response = resp;
        if (res == null) {
            res = this.request.getResource();
        }
        if (ResourceUtil.isNonExistingResource(res)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        Node node = res.adaptTo(Node.class);
        if (node == null) {
            throw new RepositoryException("No node found for resource: " + res.getPath());
        }
        Resource propRes = res;
        this.nodePath = node.getPath();
        if (node.getName().equals("jcr:content")) {
            this.nodePath = node.getParent().getPath();
        } else if (node.hasNode("jcr:content")) {
            propRes = res.getChild("jcr:content");
        }
        ValueMap props = propRes.adaptTo(ValueMap.class);
        if (node.isNodeType("nt:file")) {
            this.fileSize = props.get("jcr:data", Property.class) != null ? ((Property)((Object)props.get("jcr:data", Property.class))).getLength() : 0L;
            this.mimeType = props.get("jcr:mimeType", "application/octet-stream");
        } else {
            this.mimeType = "text/html";
        }
        this.baseUrl = this.getUrlPrefix();
        this.baseUrl = this.baseUrl + Text.getRelativeParent(this.nodePath, 1);
        this.title = props.get("jcr:title", node.getName());
        this.description = props.get("jcr:description", "");
        this.language = props.get("jcr:language", "");
        this.author = props.get("jcr:createdBy", "");
        this.publishedDate = this.formatDate(props.get("jcr:created", props.get("cq:lastModified", Calendar.getInstance())));
        this.tags = Text.implode(props.get("cq:tags", new String[0]), ",");
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public String getCharacterEncoding() {
        return "utf-8";
    }

    @Override
    public void printEntry(Resource res) throws IOException {
        this.initXml();
        try {
            this.request.setAttribute("com.day.cq.wcm.api.components.ComponentContext/bypass", "true");
            StringResponseWrapper wrapper = new StringResponseWrapper(this.response);
            this.request.getRequestDispatcher(this.getFeedEntryPath(res)).include(this.request, wrapper);
            this.xml.getWriter().print(wrapper.getString());
        }
        catch (ServletException se) {
            throw new IOException(se.getMessage());
        }
    }

    @Override
    public void printChildEntries() throws IOException {
        this.printEntries(this.request.getResourceResolver().listChildren(this.request.getResource()));
    }

    @Override
    public void printChildEntries(int max) throws IOException {
        Iterator<Resource> iter = this.request.getResourceResolver().listChildren(this.request.getResource());
        ArrayList<Resource> children = new ArrayList<Resource>();
        while (iter.hasNext()) {
            Resource res = iter.next();
            try {
                if (res.adaptTo(Node.class).getName().equals("jcr:content")) {
                    continue;
                }
            }
            catch (RepositoryException re) {
                throw new IOException(re.getMessage());
            }
            children.add(res);
        }
        this.printEntries(children.iterator(), max);
    }

    @Override
    public void printEntries(Iterator<Resource> iter) throws IOException {
        this.printEntries(iter, 0);
    }

    @Override
    public void printEntries(Iterator<Resource> iter, int max) throws IOException {
        int i = 0;
        while (iter.hasNext()) {
            this.printEntry(iter.next());
            if (max <= 0 || ++i <= max) continue;
            break;
        }
    }

    @Override
    public void printFooter() throws IOException {
        this.initXml();
        this.xml.closeDocument();
    }

    void initXml() throws IOException {
        if (this.xml == null) {
            this.xml = new SimpleXml(this.response.getWriter());
        }
    }

    String getFeedEntryPath(Resource res) {
        return res.getPath() + ".feedentry.xml";
    }

    String formatDate(Calendar calendar) {
        try {
            calendar.setTimeZone(new SimpleTimeZone(0, "UTC"));
            return String.format("%1$tFT%1$tTZ", calendar);
        }
        catch (Exception e) {
            return "";
        }
    }

    boolean isFile() {
        return this.fileSize > 0L;
    }

    String getFileSize() {
        return this.fileSize + "";
    }

    String getMimeType() {
        return this.mimeType;
    }

    String getTitle() {
        return this.title;
    }

    String getSummary() {
        return this.description;
    }

    String getDescription() {
        return this.description;
    }

    String getTags() {
        return this.tags;
    }

    String getLanguage() {
        return this.language;
    }

    String getAuthorName() {
        return this.author;
    }

    String getAuthorEmail() {
        return !"".equals(this.author) ? this.author + "@" + this.request.getServerName() : "";
    }

    String getPublishedDate() {
        return this.publishedDate;
    }

    String getNodePath() {
        return this.nodePath;
    }

    String getUrlPrefix() {
        StringBuffer url = new StringBuffer();
        int port = this.request.getServerPort();
        int defaultPort = "http".equals(this.request.getScheme()) ? 80 : ("https".equals(this.request.getScheme()) ? 443 : -1);
        url.append(this.request.getScheme());
        url.append("://");
        url.append(this.request.getServerName());
        if (port > 0 && port != defaultPort) {
            url.append(":");
            url.append(port);
        }
        url.append(this.request.getContextPath());
        return url.toString();
    }

    String getHtmlLink() {
        return this.getUrlPrefix() + this.getNodePath() + ".html";
    }

    String getFeedLink() {
        return this.getUrlPrefix() + this.getNodePath() + ".feed.xml";
    }

    String getFeedEntryLink() {
        return this.getUrlPrefix() + this.getNodePath() + ".feedentry.xml";
    }

    String getCommentsLink() {
        return this.getUrlPrefix() + this.getNodePath() + ".html#comments";
    }

    String getFileLink() {
        return this.getUrlPrefix() + this.getNodePath();
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    String getGeneratorName() {
        return "CQ5";
    }

    String getGeneratorVersion() {
        return "5.2";
    }

    String getGeneratorLink() {
        return "http://www.day.com/communique";
    }

    static {
        AbstractFeed.textNodes[0] = "par/text";
        AbstractFeed.textNodes[1] = "par/textimage";
        AbstractFeed.textNodes[2] = "blogentry";
    }
}

