/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.metadata;

import com.adobe.xmp.schema.service.SchemaServiceException;
import com.adobe.xmp.schema.service.StandardRelaxNGProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;

class DamRelaxNGProvider
extends StandardRelaxNGProvider {
    static final String NS_DAM = "http://www.day.com/dam/1.0";
    static final String DAM_SCHEMA_FULL_NAME = "xmpDamSchema/AdobePacket-dam.rng";
    static final String DAM_DEFS_NAME = "AdobeDefinitions-dam.rng";
    static final String DAM_DEFS_FULL_NAME = "xmpDamSchema/properties/AdobeDefinitions-dam.rng";

    DamRelaxNGProvider() throws SchemaServiceException {
    }

    @Override
    public InputStream getSchema(String namespaceURI) throws IOException {
        if (NS_DAM.equals(namespaceURI)) {
            try {
                return DamRelaxNGProvider.getResource(DAM_SCHEMA_FULL_NAME).toURL().openStream();
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        }
        return super.getSchema(namespaceURI);
    }

    @Override
    public InputStream getInclude(String includeName) throws IOException {
        if (DAM_DEFS_NAME.equals(includeName)) {
            try {
                return DamRelaxNGProvider.getResource(DAM_DEFS_FULL_NAME).toURL().openStream();
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        }
        return super.getInclude(includeName);
    }

    @Override
    public boolean isAvailable(String namespaceURI) {
        return NS_DAM.equals(namespaceURI) || super.isAvailable(namespaceURI);
    }

    @Override
    public Set<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(NS_DAM);
        namespaces.addAll(super.getNamespaces());
        return namespaces;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = DamRelaxNGProvider.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    private static URI getResource(String path) throws URISyntaxException {
        ClassLoader loader = DamRelaxNGProvider.getClassLoader();
        return loader.getResource(path).toURI();
    }
}

