/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.thumbnail.provider;

import com.day.cq.commons.thumbnail.ThumbnailProvider;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

@Component(metatype=false)
@Service
@Property(name="thumbnail.provider.name", value={"nt:file"})
public class FileThumbnailProvider
implements ThumbnailProvider {
    private static final String LIGHBOX_ASSETREF_SEPARATOR = "_:_";
    private static final String PROP_NAME_ASSETREFS = "assetRefs";
    private static final Pattern lightboxPattern = Pattern.compile("/home/users/(.*)/(.*)/profile/lightbox/(.*)");

    @Override
    public String getThumbnailPath(Resource resource, int width, int height, Map<String, Object> additionalConf) {
        if (this.isLightBoxAsset(resource)) {
            return this.getThumbnailPathForLightboxEntry(resource, width, height);
        }
        return null;
    }

    private String getThumbnailPathForLightboxEntry(Resource entry, int width, int height) {
        String[] assetRefs;
        String path = null;
        String lightboxPath = entry.getParent().getPath();
        ResourceResolver resolver = entry.getResourceResolver();
        ValueMap lightboxProps = ResourceUtil.getValueMap(resolver.getResource(lightboxPath));
        for (String ref : assetRefs = lightboxProps.get(PROP_NAME_ASSETREFS, new String[0])) {
            String renditionName;
            Rendition rendition;
            String assetPath;
            Resource assetResource;
            Asset asset;
            String[] fragments = StringUtils.splitByWholeSeparator(ref, LIGHBOX_ASSETREF_SEPARATOR);
            if (2 != fragments.length || !ResourceUtil.getName(entry).equals(fragments[0]) || null == (asset = (assetResource = resolver.getResource(assetPath = fragments[1])).adaptTo(Asset.class)) || null == (rendition = asset.getRendition(renditionName = "cq5dam.thumbnail." + width + "." + height + ".png"))) continue;
            path = rendition.getPath();
        }
        return path;
    }

    private boolean isLightBoxAsset(Resource resource) {
        Matcher matcher = lightboxPattern.matcher(resource.getPath());
        return matcher.matches();
    }
}

