/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.adobe.granite.ui.preview.PreviewEnabledService;
import com.day.cq.i18n.I18n;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.status.WorkflowStatus;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class AssetPublicationUtil {
    private static final String AGENT_ID = "agentId";
    private static final String AGENT_ID_PREVIEW = "preview";
    private static final String AGENT_ID_PUBLISH = "publish";
    private static final String BUILD_ENTRY_MAP = "buildEntryMap";
    private static final String BUILD_ENTRY_MAP_PREVIEW = "buildEntryMapPreview";
    private static final String SCHEDULED_ACTIVATION_WORKFLOW_ID_NEW = "/var/workflow/models/scheduled_activation";
    private static final String SCHEDULED_TREE_ACTIVATION_WORKFLOW_ID_VAR = "/var/workflow/models/scheduled_tree_activation";
    private static final String SCHEDULED_DEACTIVATION_WORKFLOW_ID_NEW = "/var/workflow/models/scheduled_deactivation";
    private static final String FT_ASSETS_PREVIEW = "ft-sites-125";

    private static String getStatus(int maxQueuePos, String actionType, I18n i18n) {
        String status = "";
        if (maxQueuePos > 0) {
            status = "Activate".equals(actionType) ? i18n.get("Publication Pending. #{0} in the queue.", "0 is the position in the queue", maxQueuePos) : i18n.get("Un-publication Pending. #{0} in the queue.", "0 is the position in the queue", maxQueuePos);
        }
        return status;
    }

    public static String getPendingStatusFromReplication(ReplicationStatus replicationStatus, I18n i18n) {
        if (replicationStatus == null) {
            return "";
        }
        String actionType = "";
        int maxQueuePos = -1;
        for (ReplicationQueue.Entry e : replicationStatus.getPending()) {
            if (e.getQueuePosition() <= maxQueuePos) continue;
            maxQueuePos = e.getQueuePosition();
            actionType = e.getAction().getType().getName();
        }
        return AssetPublicationUtil.getStatus(++maxQueuePos, actionType, i18n);
    }

    private static String getPendingStatusUsingAgents(SlingScriptHelper sling, Resource resource, I18n i18n, String agentId) {
        String path = resource.getPath();
        ReplicationStatus replicationStatus = resource.adaptTo(ReplicationStatus.class);
        if (replicationStatus != null && StringUtils.isNotEmpty(agentId)) {
            replicationStatus = replicationStatus.getStatusForAgent(agentId);
        }
        AgentManager agentMgr = sling.getService(AgentManager.class);
        if (replicationStatus == null) {
            return "";
        }
        String actionType = "";
        int maxQueuePos = -1;
        ReplicationActionType type = replicationStatus.getLastReplicationAction();
        Calendar last = replicationStatus.getLastPublished();
        if (type != null && last != null) {
            long time = last.getTimeInMillis();
            for (Agent agent : agentMgr.getAgents().values()) {
                if (agent.isInMaintenanceMode()) continue;
                if (StringUtils.isEmpty(agentId) && !StringUtils.equals(agent.getId(), AGENT_ID_PREVIEW)) {
                    maxQueuePos = Math.max(AssetPublicationUtil.findMaxPositionInAgentQueue(agent, path, type, time), maxQueuePos);
                    continue;
                }
                if (!StringUtils.equals(agent.getId(), agentId)) continue;
                maxQueuePos = Math.max(AssetPublicationUtil.findMaxPositionInAgentQueue(agent, path, type, time), maxQueuePos);
                break;
            }
        }
        return AssetPublicationUtil.getStatus(++maxQueuePos, actionType, i18n);
    }

    private static int findMaxPositionInAgentQueue(Agent agent, String path, ReplicationActionType type, long time) {
        int maxQueuePos = -1;
        ReplicationQueue queue = agent.getQueue();
        if (queue != null) {
            for (ReplicationQueue.Entry e : queue.entries(path)) {
                if (type != e.getAction().getType() || time != e.getAction().getTime() || e.getQueuePosition() <= maxQueuePos) continue;
                maxQueuePos = e.getQueuePosition();
            }
        }
        return maxQueuePos;
    }

    public static String getPendingStatusFromCache(HttpServletRequest request, Resource resource, I18n i18n) {
        return AssetPublicationUtil.computePendingStatusUsingCache(request, resource, i18n, null);
    }

    public static String getPendingStatusOfPreviewFromCache(HttpServletRequest request, Resource resource, I18n i18n) {
        return AssetPublicationUtil.computePendingStatusUsingCache(request, resource, i18n, AGENT_ID_PREVIEW);
    }

    private static String computePendingStatusUsingCache(HttpServletRequest request, Resource resource, I18n i18n, String agentId) {
        Map buildEntryMap;
        String actionType = "";
        int maxQueuePos = -1;
        String path = resource.getPath();
        String entryMapKey = BUILD_ENTRY_MAP;
        if (StringUtils.equals(agentId, AGENT_ID_PREVIEW)) {
            entryMapKey = BUILD_ENTRY_MAP_PREVIEW;
        }
        if ((buildEntryMap = (Map)request.getAttribute(entryMapKey)) != null && buildEntryMap.containsKey(path)) {
            Pair pair = (Pair)buildEntryMap.get(path);
            actionType = (String)pair.getKey();
            maxQueuePos = (Integer)pair.getValue();
        }
        return AssetPublicationUtil.getStatus(++maxQueuePos, actionType, i18n);
    }

    public static String formatTime(Locale locale, Long time) {
        DateTimeFormatter pattern = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(new Date(time).toInstant(), ZoneId.systemDefault());
        return zonedDateTime.format(pattern);
    }

    public static Calendar getLastReplicated(ValueMap properties) {
        if (properties == null) {
            return null;
        }
        return (Calendar)((Object)properties.get("cq:lastReplicated", Calendar.class));
    }

    public static Calendar getLastReplicatedPreview(ValueMap properties) {
        if (properties == null) {
            return null;
        }
        String lastReplicatedProperty = String.join((CharSequence)"_", "cq:lastReplicated", AGENT_ID_PREVIEW);
        return (Calendar)((Object)properties.get(lastReplicatedProperty, Calendar.class));
    }

    public static String getLastReplicatedBy(ValueMap properties) {
        if (properties == null) {
            return null;
        }
        return (String)((Object)properties.get("cq:lastReplicatedBy", String.class));
    }

    public static String getLastReplicatedByPreview(ValueMap properties) {
        if (properties == null) {
            return null;
        }
        String lastReplicatedByProperty = String.join((CharSequence)"_", "cq:lastReplicatedBy", AGENT_ID_PREVIEW);
        return (String)((Object)properties.get(lastReplicatedByProperty, String.class));
    }

    public static String getLastReplicationAction(ValueMap properties) {
        if (properties == null) {
            return null;
        }
        return (String)((Object)properties.get("cq:lastReplicationAction", String.class));
    }

    public static String getLastReplicationActionPreview(ValueMap properties) {
        if (properties == null) {
            return null;
        }
        String lastReplicationActionProperty = String.join((CharSequence)"_", "cq:lastReplicationAction", AGENT_ID_PREVIEW);
        return (String)((Object)properties.get(lastReplicationActionProperty, String.class));
    }

    public static String getPendingStatus(HttpServletRequest httpRequest, Resource resource, I18n i18n, SlingScriptHelper sling) {
        String pendingStatus;
        Map entryMap = (Map)httpRequest.getAttribute(BUILD_ENTRY_MAP);
        if (entryMap != null) {
            pendingStatus = AssetPublicationUtil.getPendingStatusFromCache(httpRequest, resource, i18n);
        } else if (sling == null) {
            ReplicationStatus replicationStatus = resource.adaptTo(ReplicationStatus.class);
            pendingStatus = AssetPublicationUtil.getPendingStatusFromReplication(replicationStatus, i18n);
        } else {
            pendingStatus = AssetPublicationUtil.getPendingStatusUsingAgents(sling, resource, i18n, null);
        }
        return pendingStatus;
    }

    public static String getPendingStatusOfPreview(HttpServletRequest httpRequest, Resource resource, I18n i18n, SlingScriptHelper sling) {
        Map entryMap = (Map)httpRequest.getAttribute(BUILD_ENTRY_MAP_PREVIEW);
        String pendingStatus = entryMap != null ? AssetPublicationUtil.getPendingStatusOfPreviewFromCache(httpRequest, resource, i18n) : AssetPublicationUtil.getPendingStatusUsingAgents(sling, resource, i18n, AGENT_ID_PREVIEW);
        return pendingStatus;
    }

    public static String getScheduledStatus(List<Workflow> scheduledWorkflows, I18n i18n, Resource resource, SlingHttpServletRequest httpServletRequest) {
        String resourcePath = resource.getPath();
        StringBuilder status = new StringBuilder();
        int i = 0;
        for (Workflow scheduledWorkflow : scheduledWorkflows) {
            if (i > 0) {
                status.append("\n\n");
            }
            if (AssetPublicationUtil.isScheduledActivationWorkflow(scheduledWorkflow)) {
                status.append(i18n.get("Publication Pending")).append("\n");
                try {
                    JSONObject jsonObject;
                    String version;
                    String versions = (String)((Object)scheduledWorkflow.getWorkflowData().getMetaDataMap().get("versions", String.class));
                    if (versions != null && StringUtils.isNotEmpty(version = (jsonObject = new JSONObject(versions)).get(resourcePath).toString())) {
                        status.append(i18n.get("Version")).append(": ").append(version).append("\n");
                    }
                }
                catch (JSONException jSONException) {}
            } else {
                status.append(i18n.get("Un-publication Pending")).append("\n");
            }
            status.append(i18n.get("Scheduled")).append(": ");
            status.append(AssetPublicationUtil.formatTime(httpServletRequest.getLocale(), (Long)((Object)scheduledWorkflow.getWorkflowData().getMetaDataMap().get("absoluteTime", Long.class))));
            status.append(" (").append(AuthorizableUtil.getFormattedName(httpServletRequest.getResourceResolver(), scheduledWorkflow.getInitiator())).append(")");
            ++i;
        }
        return status.toString();
    }

    public static List<Workflow> getScheduledWorkflows(WorkflowStatus workflowStatus) {
        return AssetPublicationUtil.computeScheduledWorkflows(workflowStatus, null);
    }

    public static List<Workflow> getScheduledWorkflowsOfPreview(WorkflowStatus workflowStatus) {
        return AssetPublicationUtil.computeScheduledWorkflows(workflowStatus, AGENT_ID_PREVIEW);
    }

    private static List<Workflow> computeScheduledWorkflows(WorkflowStatus workflowStatus, String agentId) {
        LinkedList<Workflow> scheduledWorkflows = new LinkedList<Workflow>();
        if (workflowStatus != null) {
            List<Workflow> workflows = workflowStatus.getWorkflows(false);
            for (Workflow workflow : workflows) {
                WorkflowData workflowData = workflow.getWorkflowData();
                MetaDataMap metaDataMap = workflowData != null ? workflow.getMetaDataMap() : null;
                if (metaDataMap == null) continue;
                String agentIdMetaData = (String)((Object)metaDataMap.get(AGENT_ID, String.class));
                if (!StringUtils.isNotEmpty(agentId) ? StringUtils.equals(agentIdMetaData, AGENT_ID_PREVIEW) : !StringUtils.equals(agentId, agentIdMetaData)) continue;
                if (!AssetPublicationUtil.isScheduledActivationWorkflow(workflow) && !AssetPublicationUtil.isScheduledDeactivationWorkflow(workflow)) continue;
                scheduledWorkflows.add(workflow);
            }
        }
        Collections.sort(scheduledWorkflows, new Comparator<Workflow>(){

            @Override
            public int compare(Workflow o1, Workflow o2) {
                return o1.getTimeStarted().compareTo(o2.getTimeStarted());
            }
        });
        return scheduledWorkflows;
    }

    public static boolean isScheduledActivationWorkflow(Workflow workflow) {
        return workflow != null && (workflow.getWorkflowModel().getId().equals("/etc/workflow/models/scheduled_activation/jcr:content/model") || workflow.getWorkflowModel().getId().equals(SCHEDULED_ACTIVATION_WORKFLOW_ID_NEW) || workflow.getWorkflowModel().getId().equals(SCHEDULED_TREE_ACTIVATION_WORKFLOW_ID_VAR));
    }

    public static boolean isScheduledDeactivationWorkflow(Workflow workflow) {
        return workflow != null && (workflow.getWorkflowModel().getId().equals("/etc/workflow/models/scheduled_deactivation/jcr:content/model") || workflow.getWorkflowModel().getId().equals(SCHEDULED_DEACTIVATION_WORKFLOW_ID_NEW));
    }

    public static boolean isPreviewEnabled(SlingScriptHelper sling) {
        PreviewEnabledService previewEnabledService = sling.getService(PreviewEnabledService.class);
        ToggleRouter toggleRtr = sling.getService(ToggleRouter.class);
        return previewEnabledService != null && previewEnabledService.isEnabled() && toggleRtr != null && toggleRtr.isEnabled(FT_ASSETS_PREVIEW);
    }
}

