/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.api;

import com.day.cq.dam.scene7.api.NotNullApi;
import java.net.URL;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
@NotNullApi
public class Scene7Endpoint
implements Comparable<Scene7Endpoint> {
    public static final int DEFAULT_PORT = 80;
    private final URL apiURL;
    private final URL ipsURL;
    private final URL spsURL;
    private final URL viewerSdkURL;
    private final String apiVersion;
    private final String region;
    private final String description;
    private final URL defaultSecurePreviewURL;

    public Scene7Endpoint(URL apiURL, URL ipsURL, URL spsURL, String apiVersion, String region, String description, @Nullable URL defaultSecurePreviewURL) {
        this.apiURL = apiURL;
        this.ipsURL = ipsURL;
        this.spsURL = spsURL;
        this.viewerSdkURL = null;
        this.apiVersion = apiVersion;
        this.region = region;
        this.description = description;
        this.defaultSecurePreviewURL = defaultSecurePreviewURL;
    }

    public Scene7Endpoint(URL apiURL, URL ipsURL, URL spsURL, URL viewerSdkURL, String apiVersion, String region, String description, @Nullable URL defaultSecurePreviewURL) {
        this.apiURL = apiURL;
        this.ipsURL = ipsURL;
        this.spsURL = spsURL;
        this.viewerSdkURL = viewerSdkURL;
        this.apiVersion = apiVersion;
        this.region = region;
        this.description = description;
        this.defaultSecurePreviewURL = defaultSecurePreviewURL;
    }

    @Deprecated
    public Scene7Endpoint(URL apiURL, URL ipsURL, URL spsURL, URL viewerSdkURL, String apiVersion, String region, String description) {
        this(apiURL, ipsURL, spsURL, viewerSdkURL, apiVersion, region, description, null);
    }

    @Deprecated
    public Scene7Endpoint(URL apiURL, URL ipsURL, URL spsURL, String apiVersion, String region, String description) {
        this(apiURL, ipsURL, spsURL, apiVersion, region, description, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Region: ").append(this.region);
        sb.append("; Description: ").append(this.description);
        sb.append("; API URL: ").append(this.apiURL);
        sb.append("; IPS URL: ").append(this.ipsURL);
        sb.append("; SPS URL: ").append(this.spsURL);
        sb.append("; Viewer SDK URL: ").append(this.viewerSdkURL != null ? this.viewerSdkURL : "");
        sb.append("; API Version: ").append(this.apiVersion);
        sb.append("; Default Secure Preview URL: ").append(this.defaultSecurePreviewURL != null ? this.defaultSecurePreviewURL : "");
        return sb.toString();
    }

    public URL getApiURL() {
        return this.apiURL;
    }

    public URL getIpsURL() {
        return this.ipsURL;
    }

    public URL getSpsURL() {
        return this.spsURL;
    }

    @Nullable
    public URL getViewerSdkURL() {
        return this.viewerSdkURL;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public URL getDefaultSecurePreviewURL() {
        return this.defaultSecurePreviewURL;
    }

    @Override
    public int compareTo(Scene7Endpoint o) {
        return this.description.compareTo(o.description);
    }

    public boolean equals(Object obj) {
        return obj instanceof Scene7Endpoint && this.description.equals(((Scene7Endpoint)obj).description);
    }

    public int hashCode() {
        return this.description.hashCode();
    }
}

