/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.api.model;

import com.day.cq.dam.scene7.api.model.Scene7AssetSetMember;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Scene7AssetSet {
    private final List<Scene7AssetSetMember> members;

    public Scene7AssetSet(List<Scene7AssetSetMember> members) {
        this.members = members != null ? members : new LinkedList();
    }

    public List<Scene7AssetSetMember> getAssetSetMembers() {
        return this.members;
    }

    public String toString() {
        if (this.members.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.members.size() * 30);
        for (Scene7AssetSetMember member : this.members) {
            String preset;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (Scene7AssetSetMember.Type.SPIN_SET_ROW.equals((Object)member.getType())) {
                if (this.members.size() > 1) {
                    sb.append('{');
                }
                boolean first = true;
                for (String h : member.getHandles()) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append("${getCatalogId([").append(h).append("])}");
                    first = false;
                }
                if (this.members.size() <= 1) continue;
                sb.append('}');
                continue;
            }
            for (String h : member.getHandles()) {
                sb.append("${getCatalogId([").append(h).append("])};");
            }
            if (member.getType() == null || !StringUtils.isNotEmpty(preset = member.getType().toString())) continue;
            sb.append(preset).append(';');
        }
        return sb.toString();
    }
}

