/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.api.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Scene7AssetSetMember {
    private final Type type;
    private final List<String> handles;

    public Scene7AssetSetMember(Type type, List<String> handles) {
        this.type = type;
        this.handles = handles != null ? handles : new LinkedList();
    }

    public Scene7AssetSetMember(String type, List<String> handles) {
        this(Type.from(type), handles);
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getHandles() {
        return this.handles;
    }

    public static enum Type {
        IMAGE,
        IMAGESET,
        RENDERSET,
        SPINSET,
        SPINSET2D,
        REMIX,
        VIDEO,
        VIEWERSWF,
        MULTIBITRATEVIDEOSET,
        SPIN_SET_ROW,
        OTHER;

        private static final Map<Type, String> MAPPINGS;

        public String toString() {
            return MAPPINGS.get((Object)this);
        }

        static Type from(String value) {
            switch (value) {
                case "advanced_image": {
                    return IMAGE;
                }
                case "advanced_imageset": {
                    return IMAGESET;
                }
                case "advanced_swatchset": {
                    return RENDERSET;
                }
                case "spin": {
                    return SPINSET;
                }
                case "video": {
                    return VIDEO;
                }
                case "video_set": {
                    return MULTIBITRATEVIDEOSET;
                }
                case "SpinSetRow": {
                    return SPIN_SET_ROW;
                }
            }
            String msg = "\"%s\" is not a valid value";
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid value", value));
        }

        static {
            MAPPINGS = new HashMap<Type, String>();
            MAPPINGS.put(IMAGE, "advanced_image");
            MAPPINGS.put(IMAGESET, "advanced_imageset");
            MAPPINGS.put(RENDERSET, "advanced_swatchset");
            MAPPINGS.put(SPINSET, "spin");
            MAPPINGS.put(SPINSET2D, "spin");
            MAPPINGS.put(REMIX, "video");
            MAPPINGS.put(VIDEO, "video");
            MAPPINGS.put(VIEWERSWF, "video");
            MAPPINGS.put(MULTIBITRATEVIDEOSET, "video_set");
            MAPPINGS.put(SPIN_SET_ROW, "SpinSetRow");
        }
    }
}

