/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.commons;

import com.day.cq.mailer.AuthorizableMailingList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;

public class AuthorizableGroupMailingList
implements AuthorizableMailingList {
    private final Group group;
    private Predicate<Authorizable> filterPredicate;

    public AuthorizableGroupMailingList(Group group) {
        this(group, (Predicate<Authorizable>)null);
    }

    @Deprecated
    public AuthorizableGroupMailingList(Group group, final org.apache.commons.collections.Predicate oldFilterPredicate) {
        this.group = group;
        this.filterPredicate = new Predicate<Authorizable>(){

            @Override
            public boolean evaluate(Authorizable authorizable) {
                return oldFilterPredicate.evaluate(authorizable);
            }
        };
    }

    public AuthorizableGroupMailingList(Group group, Predicate<Authorizable> filterPredicate) {
        this.group = group;
        this.filterPredicate = filterPredicate;
    }

    @Override
    public Iterator<Authorizable> members() throws RepositoryException {
        if (this.filterPredicate == null) {
            return new GroupUnfoldingIterator(this.group.getDeclaredMembers());
        }
        return IteratorUtils.filteredIterator(new GroupUnfoldingIterator(this.group.getDeclaredMembers()), this.filterPredicate);
    }

    private static final class GroupUnfoldingIterator
    implements Iterator<Authorizable> {
        private final Stack<Iterator<Authorizable>> iterators = new Stack();
        private final HashSet<String> served = new HashSet();
        private Authorizable next;

        GroupUnfoldingIterator(Iterator<Authorizable> base) throws RepositoryException {
            this.iterators.push(base);
            this.next = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Authorizable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Authorizable serve = this.next;
            try {
                this.next = this.seek();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            return serve;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seek() throws RepositoryException {
            while (!this.iterators.isEmpty()) {
                Iterator<Authorizable> current = this.iterators.pop();
                while (current != null && current.hasNext()) {
                    Authorizable test = current.next();
                    if (this.served.contains(test.getID())) continue;
                    this.served.add(test.getID());
                    if (current.hasNext()) {
                        this.iterators.push(current);
                    }
                    if (test.isGroup()) {
                        this.iterators.push(((Group)test).getDeclaredMembers());
                    }
                    return test;
                }
            }
            return null;
        }
    }
}

