/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class ContextProfileHtmlInputTag
extends TagSupport {
    private static final long serialVersionUID = 4646561799994266940L;
    private String propertyName;
    private String store;
    private String id;
    private String clazz;
    private String type;
    private String name;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.propertyName = null;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        try {
            out.println(this.getScript(request, request.adaptTo(UserProperties.class)));
        }
        catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }
        return 6;
    }

    String getScript(SlingHttpServletRequest request, UserProperties userProperties) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);
        StringBuilder res = new StringBuilder();
        boolean isDisabled = WCMMode.fromRequest(request).equals((Object)WCMMode.DISABLED);
        res.append("<input");
        res.append(" id=\"").append(xssAPI.encodeForHTMLAttr(this.id)).append("\"");
        res.append(" class=\"").append(xssAPI.encodeForHTMLAttr(this.clazz)).append("\"");
        res.append(" type=\"").append(xssAPI.encodeForHTMLAttr(this.type)).append("\"");
        res.append(" name=\"").append(xssAPI.encodeForHTMLAttr(this.name)).append("\"");
        res.append("/>");
        if (!isDisabled) {
            res.append("<script type=\"text/javascript\">");
            res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
            res.append("$CQ(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(this.propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(this.id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("}");
            res.append("CQ_Analytics.CCM.onReady(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store && store.addListener) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(this.propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(this.id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("store.addListener('update', function() {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(this.propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(this.id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("});");
            res.append("}");
            res.append("});");
            res.append("});");
            res.append("}");
            res.append("</script>");
        } else {
            res.append("<script type=\"text/javascript\">");
            res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
            res.append("$CQ(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(this.propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(this.id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("}");
            res.append("CQ_Analytics.CCM.onReady(function() {");
            res.append("var store = CQ_Analytics.CCM.getRegisteredStore(CQ_Analytics.ProfileDataMgr.STORENAME);");
            res.append("if(store) {");
            res.append("var name = store.getProperty('").append(xssAPI.encodeForJSString(this.propertyName)).append("', true) || '';");
            res.append("var el = document.getElementById('").append(xssAPI.encodeForJSString(this.id)).append("');");
            res.append("if( el) {");
            res.append("el.value = name;");
            res.append("}");
            res.append("}");
            res.append("});");
            res.append("});");
            res.append("}");
            res.append("</script>");
        }
        return res.toString();
    }
}

