/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.ReplicationAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.osgi.service.event.Event;

public class ReplicatedAction {
    public static final String PROPERTY_AGENT_IDS = "agentIds";
    private final ReplicationAction replicationAction;
    private final List<String> agentIds;

    public ReplicatedAction(@Nonnull ReplicationAction replicationAction, List<String> agentIds) {
        this.replicationAction = replicationAction;
        this.agentIds = agentIds != null ? Collections.unmodifiableList(agentIds) : null;
    }

    public ReplicationAction getReplicationAction() {
        return this.replicationAction;
    }

    public List<String> getAgentIds() {
        return this.agentIds;
    }

    public static ReplicatedAction fromEvent(Event evt) {
        ReplicationAction replicationAction = ReplicationAction.fromEvent(evt);
        if (replicationAction != null) {
            return new ReplicatedAction(replicationAction, (List)evt.getProperty(PROPERTY_AGENT_IDS));
        }
        return null;
    }

    public Event toEvent(boolean distributeEvents) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.replicationAction.createEventProperties(distributeEvents));
        if (this.agentIds != null) {
            properties.put(PROPERTY_AGENT_IDS, this.agentIds);
        }
        return new Event("com/day/cq/replication", properties);
    }
}

