/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.XPath;
import java.math.BigDecimal;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceVendor(value="Adobe Systems Incorporated")
@Component(factory="com.day.cq.search.eval.PredicateEvaluator/rangeproperty")
public class RangePropertyPredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RangePropertyPredicateEvaluator.class);
    public static final String PROPERTY = "property";
    public static final String LOWER_BOUND = "lowerBound";
    public static final String LOWER_OPERATION = "lowerOperation";
    public static final String UPPER_BOUND = "upperBound";
    public static final String UPPER_OPERATION = "upperOperation";
    public static final String PROPERTY_DECIMAL = "decimal";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (p.getBool(PROPERTY_DECIMAL)) {
            return null;
        }
        return this.getXPathExpression(p.get(PROPERTY), p.get(LOWER_BOUND), p.get(LOWER_OPERATION), p.get(UPPER_BOUND), p.get(UPPER_OPERATION));
    }

    protected String getXPathExpression(String property, String lowerValue, String lowerOperation, String upperValue, String upperOperation) {
        String op;
        StringBuffer buffer = new StringBuffer();
        if (lowerValue != null) {
            op = lowerOperation;
            if (!">".equals(op) && !">=".equals(op)) {
                op = ">";
            }
            buffer.append(XPath.getPropertyPath(property)).append(" ").append(op).append(" ").append(lowerValue);
        }
        if (upperValue != null) {
            if (buffer.length() > 1) {
                buffer.append(" and ");
            }
            if (!"<".equals(op = upperOperation) && !"<=".equals(op)) {
                op = "<";
            }
            buffer.append(XPath.getPropertyPath(property)).append(" ").append(op).append(" ").append(upperValue);
        }
        if (buffer.length() > 0) {
            return "(" + buffer.toString() + ")";
        }
        return null;
    }

    @Override
    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{p.get(PROPERTY)};
    }

    @Override
    public boolean canXpath(Predicate p, EvaluationContext context) {
        return !p.getBool(PROPERTY_DECIMAL);
    }

    @Override
    public boolean canFilter(Predicate p, EvaluationContext context) {
        return true;
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        return this.includes(context.getNode(row), p.get(PROPERTY), p.get(LOWER_BOUND), p.get(LOWER_OPERATION), p.get(UPPER_BOUND), p.get(UPPER_OPERATION), p.getBool(PROPERTY_DECIMAL));
    }

    protected boolean includes(Node node, String property, String lowerValue, String lowerOperation, String upperValue, String upperOperation, boolean decimal) {
        block56: {
            if (property == null || property.length() == 0 || (lowerValue == null || lowerValue.length() == 0) && (upperValue == null || upperValue.length() == 0)) {
                return true;
            }
            String path = null;
            try {
                path = node.getPath();
                if (!node.hasProperty(property)) {
                    return false;
                }
                Property nodeProperty = node.getProperty(property);
                if (decimal) {
                    boolean match;
                    if (nodeProperty.getType() != 12) {
                        return false;
                    }
                    if (lowerValue != null) {
                        BigDecimal bdLowerValue = new BigDecimal(lowerValue);
                        if (nodeProperty.isMultiple()) {
                            match = false;
                            for (Value value : nodeProperty.getValues()) {
                                if ((!">=".equals(lowerOperation) || value.getDecimal().compareTo(bdLowerValue) < 0) && (">=".equals(lowerOperation) || value.getDecimal().compareTo(bdLowerValue) <= 0)) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                return false;
                            }
                        } else if (">=".equals(lowerOperation) && nodeProperty.getDecimal().compareTo(bdLowerValue) < 0 || !">=".equals(lowerOperation) && nodeProperty.getDecimal().compareTo(bdLowerValue) <= 0) {
                            return false;
                        }
                    }
                    if (upperValue != null) {
                        BigDecimal bdUpperValue = new BigDecimal(upperValue);
                        if (nodeProperty.isMultiple()) {
                            match = false;
                            for (Value value : nodeProperty.getValues()) {
                                if ((!"<=".equals(upperOperation) || value.getDecimal().compareTo(bdUpperValue) > 0) && ("<=".equals(upperOperation) || value.getDecimal().compareTo(bdUpperValue) >= 0)) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                return false;
                            }
                        } else if ("<=".equals(upperOperation) && nodeProperty.getDecimal().compareTo(bdUpperValue) > 0 || !"<=".equals(upperOperation) && nodeProperty.getDecimal().compareTo(bdUpperValue) >= 0) {
                            return false;
                        }
                    }
                    break block56;
                }
                boolean longValue = false;
                boolean doubleValue = false;
                long lLowerValue = 0L;
                long lUpperValue = 0L;
                double dLowerValue = 0.0;
                double dUpperValue = 0.0;
                try {
                    if (lowerValue != null) {
                        lLowerValue = Long.parseLong(lowerValue);
                    }
                    if (upperValue != null) {
                        lUpperValue = Long.parseLong(upperValue);
                    }
                    longValue = true;
                }
                catch (NumberFormatException e) {
                    try {
                        if (lowerValue != null) {
                            dLowerValue = Double.parseDouble(lowerValue);
                        }
                        if (upperValue != null) {
                            dUpperValue = Double.parseDouble(upperValue);
                        }
                        doubleValue = true;
                    }
                    catch (NumberFormatException e2) {
                        log.warn("invalid values for rangeproperty includes <{},{}>", (Object)lowerValue, (Object)upperValue);
                        return true;
                    }
                }
                if (longValue) {
                    if (nodeProperty.getType() != 3) {
                        return false;
                    }
                    if (lowerValue != null) {
                        if (nodeProperty.isMultiple()) {
                            boolean match = false;
                            for (Value value : nodeProperty.getValues()) {
                                if ((!">=".equals(lowerOperation) || value.getLong() < lLowerValue) && (">=".equals(lowerOperation) || value.getLong() <= lLowerValue)) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                return false;
                            }
                        } else if (">=".equals(upperOperation) && nodeProperty.getLong() < lUpperValue || !">".equals(upperOperation) && nodeProperty.getLong() <= lUpperValue) {
                            return false;
                        }
                    }
                    if (upperValue != null) {
                        if (nodeProperty.isMultiple()) {
                            boolean match = false;
                            for (Value value : nodeProperty.getValues()) {
                                if ((!"<=".equals(upperOperation) || value.getLong() > lUpperValue) && ("<=".equals(upperOperation) || value.getLong() >= lUpperValue)) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                return false;
                            }
                        } else if ("<=".equals(upperOperation) && nodeProperty.getLong() > lUpperValue || !"<=".equals(upperOperation) && nodeProperty.getLong() >= lUpperValue) {
                            return false;
                        }
                    }
                } else if (doubleValue) {
                    if (nodeProperty.getType() != 4) {
                        return false;
                    }
                    if (lowerValue != null) {
                        if (nodeProperty.isMultiple()) {
                            boolean match = false;
                            for (Value value : nodeProperty.getValues()) {
                                if (!(">=".equals(lowerOperation) && value.getDouble() >= dLowerValue) && (">=".equals(lowerOperation) || !(value.getDouble() > dLowerValue))) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                return false;
                            }
                        } else if (">=".equals(lowerOperation) && nodeProperty.getDouble() < dLowerValue || !">=".equals(lowerOperation) && nodeProperty.getDouble() <= dLowerValue) {
                            return false;
                        }
                    }
                    if (upperValue != null) {
                        if (nodeProperty.isMultiple()) {
                            boolean match = false;
                            for (Value value : nodeProperty.getValues()) {
                                if (!("<=".equals(upperOperation) && value.getDouble() <= dUpperValue) && ("<=".equals(upperOperation) || !(value.getDouble() < dUpperValue))) continue;
                                match = true;
                                break;
                            }
                            if (!match) {
                                return false;
                            }
                        } else if ("<=".equals(upperOperation) && nodeProperty.getDouble() > dUpperValue || !"<=".equals(upperOperation) && nodeProperty.getDouble() >= dUpperValue) {
                            return false;
                        }
                    }
                }
            }
            catch (ValueFormatException e) {
                log.warn("Could not evaluate range: property = '" + property + "', node = '" + path + "'", e);
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Could not evaluate range: property = '" + property + "', node = '" + path + "'", e);
            }
        }
        return true;
    }
}

