/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.servlet.ServletRequest;

public enum DebugFlag {
    LAYOUT,
    MDEV,
    MDEVC;

    public static final String REQUEST_ATTRIBUTE_NAME;
    public static final String DEBUG_PARAM_NAME = "debug";

    public static Set<DebugFlag> fromRequest(ServletRequest req) {
        Set<DebugFlag> flag = (Set<DebugFlag>)req.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (flag == null) {
            flag = Collections.emptySet();
        }
        return flag;
    }

    public static Set<DebugFlag> fromRequestParameter(ServletRequest request, String parameterName) {
        Set dFlag = (Set)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (dFlag == null) {
            String[] debugValues = request.getParameterValues(DEBUG_PARAM_NAME);
            if (debugValues != null) {
                dFlag = EnumSet.noneOf(DebugFlag.class);
                for (String m : request.getParameterValues(DEBUG_PARAM_NAME)) {
                    try {
                        dFlag.add(DebugFlag.valueOf(m.toUpperCase()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                dFlag = Collections.unmodifiableSet(dFlag);
            } else {
                dFlag = Collections.emptySet();
            }
            request.setAttribute(REQUEST_ATTRIBUTE_NAME, dFlag);
        }
        return dFlag;
    }

    static {
        REQUEST_ATTRIBUTE_NAME = DebugFlag.class.getName();
    }
}

