/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api.components;

import com.day.cq.wcm.api.components.ChildEditor;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;

public class InplaceEditingConfig {
    public static final String PN_ACTIVE = "active";
    public static final String PN_EDITOR_TYPE = "editorType";
    public static final String PN_CONFIG_PATH = "configPath";
    public static final String NN_CONFIG_DEFAULT = "/config";
    static final String NN_CHILD_EDITORS = "cq:childEditors";
    private final boolean isActive;
    private final String editorType;
    private final String configPath;
    private Map<String, ChildEditor> childEditors;

    public InplaceEditingConfig(Node configNode) throws RepositoryException {
        this.editorType = JcrUtils.getStringProperty(configNode, PN_EDITOR_TYPE, null);
        this.isActive = this.editorType != null && JcrUtils.getBooleanProperty(configNode, PN_ACTIVE, false);
        String configPath = JcrUtils.getStringProperty(configNode, PN_CONFIG_PATH, configNode.getPath() + NN_CONFIG_DEFAULT);
        if (!configPath.startsWith("/")) {
            String basePath = configNode.getPath();
            configPath = basePath + "/" + configPath;
        }
        this.configPath = configPath;
        LinkedHashMap<String, ChildEditor> myChildEditors = null;
        if (configNode.hasNode(NN_CHILD_EDITORS)) {
            NodeIterator iter = configNode.getNode(NN_CHILD_EDITORS).getNodes();
            while (iter.hasNext()) {
                if (myChildEditors == null) {
                    myChildEditors = new LinkedHashMap<String, ChildEditor>();
                }
                ChildEditor ce = new ChildEditor(iter.nextNode());
                myChildEditors.put(ce.getId(), ce);
            }
        }
        if (myChildEditors != null) {
            this.childEditors = myChildEditors;
        }
    }

    public InplaceEditingConfig(InplaceEditingConfig config) {
        this.isActive = config.isActive();
        this.editorType = config.getEditorType();
        this.configPath = config.getConfigPath();
        this.childEditors = config.getChildEditors();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getEditorType() {
        return this.editorType;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public Map<String, ChildEditor> getChildEditors() {
        return this.childEditors;
    }
}

