/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api.components;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;

public class Toolbar
implements List<Item> {
    private final List<Item> items;

    public Toolbar() {
        this.items = new LinkedList<Item>();
    }

    public Toolbar(Item ... items) {
        this.items = new LinkedList<Item>();
        this.items.addAll(Arrays.asList(items));
    }

    public Toolbar(Collection<? extends Item> items) {
        this.items = new LinkedList<Item>();
        this.items.addAll(items);
    }

    public Toolbar(Toolbar toolbar) {
        this.items = toolbar == null ? Collections.emptyList() : Collections.unmodifiableList(toolbar);
    }

    public void write(JSONWriter writer, String key) throws JSONException {
        if (key != null) {
            writer.key(key);
        }
        writer.array();
        for (Item item : this.items) {
            item.write(writer);
        }
        writer.endArray();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.items.toArray(a);
    }

    @Override
    public boolean add(Item o) {
        return this.items.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Item> c) {
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Item> c) {
        return this.items.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(c);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Toolbar toolbar = (Toolbar)o;
        return this.items == null ? toolbar.items == null : this.items.equals(toolbar.items);
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public Item get(int index) {
        return this.items.get(index);
    }

    @Override
    public Item set(int index, Item element) {
        return this.items.set(index, element);
    }

    @Override
    public void add(int index, Item element) {
        this.items.add(index, element);
    }

    @Override
    public Item remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<Item> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<Item> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public List<Item> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    public static class Separator
    implements Item {
        @Override
        public void write(JSONWriter writer) throws JSONException {
            writer.object();
            writer.key("xtype").value("tbseparator");
            writer.endObject();
        }
    }

    public static class Label
    implements Item {
        private final String text;

        public Label(String text) {
            this.text = text;
        }

        @Override
        public void write(JSONWriter writer) throws JSONException {
            writer.object();
            writer.key("xtype").value("tbtext");
            writer.key("text").value(this.text);
            writer.endObject();
        }
    }

    public static class Button
    extends JSONObject
    implements Item {
        public Button(String text, String handler) {
            this(text, handler, false, null);
        }

        public Button(String text, String handler, boolean disabled, String tooltip) {
            try {
                this.put("xtype", "button");
                this.put("text", text);
                this.put("handler", handler);
                if (tooltip != null) {
                    this.put("tooltip", tooltip);
                }
                if (disabled) {
                    this.put("disabled", true);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }

        public Button setText(String text) {
            try {
                this.put("text", text);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public Button setHandler(String handler) {
            try {
                this.put("handler", handler);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public Button setTooltip(String tooltip) {
            try {
                this.put("tooltip", tooltip);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public Button setDisabled(boolean disabled) {
            try {
                this.put("disabled", disabled);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        @Override
        public void write(JSONWriter writer) throws JSONException {
            writer.value(this);
        }
    }

    public static class Custom
    extends JSONObject
    implements Item {
        @Override
        public void write(JSONWriter writer) throws JSONException {
            writer.value(this);
        }
    }

    public static interface Item {
        public void write(JSONWriter var1) throws JSONException;
    }
}

