/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.wcm.designimporter.parser.taghandlers.DefaultTagHandler;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jcr.RepositoryException;
import org.xml.sax.Attributes;

public class IFrameTagHandler
extends DefaultTagHandler {
    private String rawSrc;
    private String normalizedSrc;
    private boolean normalizationRequired = true;
    private String normalizationPrefix = "<%= currentDesign.getPath() %>/";

    public String getRawSrc() {
        return this.rawSrc;
    }

    public boolean isRawSrcAbsolute() {
        return this.isAbsoluteUrl(this.rawSrc);
    }

    public void setNormalizationPrefix(String normalizationPrefix) {
        this.normalizationPrefix = normalizationPrefix;
    }

    public boolean isNormalizationRequired() {
        return this.normalizationRequired;
    }

    public void setNormalizationRequired(boolean normalizationRequired) {
        this.normalizationRequired = normalizationRequired;
    }

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        super.beginHandling(uri, localName, qName, atts);
        this.normalizedSrc = this.rawSrc = atts.getValue("src");
    }

    @Override
    protected String getStartTag(String uri, String localName, String qName, Attributes atts) {
        if (this.rawSrc != null && !this.isRawSrcAbsolute() && this.isNormalizationRequired()) {
            this.normalizedSrc = this.normalizationPrefix + this.rawSrc;
        }
        String startTag = "<" + localName.toLowerCase();
        String att = "";
        for (int i = 0; i < atts.getLength(); ++i) {
            String attrName = atts.getLocalName(i);
            String attrValue = atts.getValue(i);
            att = "src".equalsIgnoreCase(attrName) ? att + " " + attrName + "=\"" + this.normalizedSrc + "\"" : att + " " + attrName + "=\"" + attrValue + "\"";
        }
        startTag = startTag + att;
        startTag = startTag + ">";
        try {
            if (!this.designImporterContext.designNode.hasNode(this.rawSrc)) {
                this.designImporterContext.importWarnings.add("Could not locate the referenced html '" + this.rawSrc + "' in the design package");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return startTag;
    }

    protected boolean isAbsoluteUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

