/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.parser.taghandlers.DefaultTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class TextComponentTagHandler
extends AbstractTagHandler {
    private String suffix;
    private Logger logger = LoggerFactory.getLogger(TextComponentTagHandler.class);
    private String resourceType;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);
        if ("p".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) {
                modAttibutes.removeAttribute(index);
            }
            this.startElement(uri, localName, qName, modAttibutes);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.startElement(uri, localName, qName, atts);
        if (!(this.delegate instanceof DefaultTagHandler)) {
            throw new UnsupportedTagContentException("049");
        }
    }

    private String getDesignPath() {
        try {
            String designPath = this.designImporterContext.designNode.getPath();
            return designPath;
        }
        catch (RepositoryException e) {
            this.logger.error("Error occurred while trying to access the path of the design node", e);
            return "";
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if ("p".equalsIgnoreCase(localName)) {
            this.endElement(uri, localName, qName);
        }
        HashMap<String, Object> base = new HashMap<String, Object>();
        base.put("text", this.processInnerHtml(this.htmlBuffer.toString()));
        base.put("textIsRich", true);
        ValueMapDecorator properties = new ValueMapDecorator(base);
        this.suffix = this.designImporterContext.componentSuffixGenerator.getSuffix("text");
        PageComponent textComponent = this.pageBuilder.createComponent(this.resourceType, properties, this.getNameHint());
        this.getPageComponents().add(textComponent);
    }

    private String processInnerHtml(String string) {
        return string.replace("<%= currentDesign.getPath() %>", this.getDesignPath());
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.MARKUP;
    }

    private String getNameHint() {
        return "text" + this.suffix;
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=\"" + this.getNameHint() + "\"" + "/>";
            return this.componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(this.componentDivStartTag);
        }
        return null;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}

