/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.cq.wcm.ui.components.container.service.AllowedComponents;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.foundation.model.impl.TemplateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AllowedComponentList
extends WCMUsePojo {
    private static final Logger log = LoggerFactory.getLogger(AllowedComponentList.class);
    private static final String PLACEHOLDER_COMPONENT_PATH = "wcm/foundation/components/parsys/placeholder";
    public static final String STRUCTURE_JCR_CONTENT = "/structure/jcr:content/";
    public static final String POLICIES_JCR_CONTENT = "/policies/jcr:content/";
    private List<ComponentMapping> componentMappings;
    private List<Component> sortedComponents = Collections.EMPTY_LIST;

    @Override
    public void activate() throws Exception {
        AllowedComponents acs = this.getSlingScriptHelper().getService(AllowedComponents.class);
        this.sortedComponents = acs.getAllowedComponents(this.getResource());
        Collections.sort(this.sortedComponents, new ComponentComparator());
    }

    public String getTitle() {
        I18n i18n = new I18n(this.getRequest());
        String containerName = i18n.getVar(this.getComponent().getTitle());
        String text = !this.sortedComponents.isEmpty() ? containerName : i18n.get("No allowed components for {0}", "No components have been allowed to be added to the container. Container name is 0 and is translated.", containerName);
        return text;
    }

    public boolean isApplicable() {
        return TemplateUtil.isContainerStructureUnlock((Page)this.getCurrentPage(), (Resource)this.getResource());
    }

    private String getRelativePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String[] searchPaths = resource.getResourceResolver().getSearchPath();
        for (int i = 0; i < searchPaths.length; ++i) {
            String searchPath = searchPaths[i];
            if (!resource.getPath().startsWith(searchPath)) continue;
            String resourcePath = resource.getPath();
            return resourcePath.substring(searchPath.length(), resourcePath.length());
        }
        return null;
    }

    public List getComponents() {
        if (this.componentMappings != null) {
            return this.componentMappings;
        }
        this.componentMappings = new ArrayList<ComponentMapping>();
        String resourcePath = this.getResource().getPath();
        for (Component component : this.sortedComponents) {
            Resource componentResource = component.adaptTo(Resource.class);
            String key = resourcePath + "/" + this.getRelativePath(componentResource);
            this.getRequest().setAttribute(key, componentResource);
            this.componentMappings.add(new ComponentMapping(key, PLACEHOLDER_COMPONENT_PATH, "aem-AllowedComponent--component"));
        }
        return this.componentMappings;
    }

    public String getCssClass() {
        String isEmpty = this.getComponents().isEmpty() ? " is-empty" : "";
        return this.isApplicable() ? "aem-AllowedComponent--list" + isEmpty : "";
    }

    public static class ComponentMapping {
        private String path;
        private String resourceType;
        private String cssClass;

        public ComponentMapping(String path, String resourceType, String cssClass) {
            this.path = path;
            this.resourceType = resourceType;
            this.cssClass = cssClass;
        }

        public String getPath() {
            return this.path;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    private class ComponentComparator
    implements Comparator<Component> {
        private ComponentComparator() {
        }

        @Override
        public int compare(Component comp1, Component comp2) {
            if (comp1 != null && comp2 != null) {
                String comp2Title;
                String comp1Title = comp1.getTitle();
                if (comp1Title == null ^ (comp2Title = comp2.getTitle()) == null) {
                    return comp1Title == null ? -1 : 1;
                }
                if (comp1Title == null) {
                    return 0;
                }
                return comp1Title.compareToIgnoreCase(comp2Title);
            }
            return 0;
        }
    }
}

