/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class MergedValueMap
implements ValueMap {
    private List<Resource> resources;
    private Map<String, Object> cache;

    public MergedValueMap(List<Resource> resources) {
        this.resources = resources;
    }

    protected void readFully() {
        if (this.cache == null) {
            this.cache = this.fetchAndMergeAllValues();
        }
    }

    protected Map<String, Object> fetchAndMergeAllValues() {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        boolean firstResource = true;
        for (Resource resource : this.resources) {
            ValueMap map = resource.adaptTo(ValueMap.class);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    if (mergedMap.containsKey(key)) {
                        Object newValue;
                        Object value = mergedMap.get(key);
                        if (value == null || (newValue = entry.getValue()) != null && value.equals(newValue)) continue;
                        mergedMap.put(key, null);
                        continue;
                    }
                    if (firstResource) {
                        mergedMap.put(key, entry.getValue());
                        continue;
                    }
                    mergedMap.put(key, null);
                }
            }
            firstResource = false;
        }
        return mergedMap;
    }

    @Override
    public Object get(Object key) {
        this.readFully();
        Object value = this.cache.get(key);
        if (value == null) {
            value = this.read((String)key);
        }
        return value;
    }

    private Object read(String key) {
        Object value = null;
        boolean firstResource = true;
        boolean isArray = false;
        for (Resource resource : this.resources) {
            ValueMap map = resource.adaptTo(ValueMap.class);
            if (map != null) {
                if (firstResource) {
                    value = map.get(key);
                    if (value == null) break;
                    isArray = value.getClass().isArray();
                } else {
                    Object newValue = map.get(key);
                    if (newValue == null) {
                        value = null;
                        break;
                    }
                    boolean newIsArray = newValue.getClass().isArray();
                    if (isArray != newIsArray || isArray && !Arrays.equals((Object[])value, (Object[])newValue) || !isArray && !ObjectUtils.equals(value, newValue)) {
                        value = null;
                        break;
                    }
                }
            }
            firstResource = false;
        }
        this.cache.put(key, value);
        return value;
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        this.readFully();
        if (type == null) {
            return (T)this.get(name);
        }
        return this.convert(this.get(name), type);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        this.readFully();
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    @Override
    public int size() {
        this.readFully();
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        this.readFully();
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.readFully();
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        return this.cache.entrySet();
    }

    @Override
    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.readFully();
        return this.cache.values();
    }

    private <T> T convert(Object obj, Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (obj instanceof Calendar && type == String.class) {
                return (T)ISO8601.format((Calendar)obj);
            }
            if (type == String.class) {
                return (T)String.valueOf(obj);
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(obj.toString()));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(obj.toString()));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(obj.toString()));
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(obj.toString()));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private <T> T[] convertToArray(Object obj, Class<T> type) {
        LinkedList<T> values = new LinkedList<T>();
        if (obj.getClass().isArray()) {
            for (Object o : (Object[])obj) {
                values.add(this.convert(o, type));
            }
        } else {
            values.add(this.convert(obj, type));
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }
}

