/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.utils;

import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.sling.JsonObjectCreator;

public class RTEUtils {
    private static final String PROPERTY_TEXT_IS_RICH = "textIsRich";
    private static final String INFINITY = "infinity";

    public static void createFilteredJSONResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, String propertyName, XSSAPI xssApi, boolean filterXSS) throws JSONException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONObject jsonObj = JsonObjectCreator.create(request.getResource(), RTEUtils.getMaxRecursionLevel(request));
        if (filterXSS) {
            RTEUtils.filterJSONObject(jsonObj, propertyName, xssApi);
        }
        response.getWriter().write(jsonObj.toString());
    }

    protected static int getMaxRecursionLevel(SlingHttpServletRequest req) throws IllegalArgumentException {
        int maxRecursionLevels = 0;
        String[] selectors = req.getRequestPathInfo().getSelectors();
        if (selectors.length > 0) {
            String level = selectors[selectors.length - 1];
            if (INFINITY.equals(level)) {
                maxRecursionLevels = -1;
            } else {
                try {
                    maxRecursionLevels = Integer.parseInt(level);
                }
                catch (NumberFormatException nfe) {
                    if (StringUtils.isNumeric(level)) {
                        maxRecursionLevels = -1;
                    }
                    throw new IllegalArgumentException("Invalid recursion selector value '" + level + "'");
                }
            }
        }
        return maxRecursionLevels;
    }

    protected static void filterJSONObject(JSONObject jsonObj, String propertyName, XSSAPI xssApi) throws JSONException {
        boolean textIsRich = jsonObj.has(PROPERTY_TEXT_IS_RICH) && "true".equals(jsonObj.getString(PROPERTY_TEXT_IS_RICH));
        Iterator<String> keys = jsonObj.keys();
        while (keys.hasNext()) {
            String k = keys.next();
            Object o = jsonObj.get(k);
            if (o instanceof String && k.equals(propertyName) && textIsRich) {
                jsonObj.put(k, xssApi.filterHTML(jsonObj.getString(k)));
                continue;
            }
            if (!(o instanceof JSONObject)) continue;
            RTEUtils.filterJSONObject(jsonObj.getJSONObject(k), propertyName, xssApi);
        }
    }
}

