/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.msm.api;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveRelationship;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public interface RolloutManager {
    public void rollout(RolloutParams var1) throws WCMException;

    public void rollout(ResourceResolver var1, LiveRelationship var2, boolean var3) throws WCMException;

    public void rollout(ResourceResolver var1, LiveRelationship var2, boolean var3, boolean var4) throws WCMException;

    public void updateRolloutInfo(Node var1, boolean var2, boolean var3) throws WCMException;

    public boolean isExcludedProperty(String var1);

    public boolean isExcludedProperty(boolean var1, String var2);

    public boolean isExcludedPageProperty(String var1);

    public boolean isExcludedParagraphProperty(String var1);

    public boolean isExcludedNodeType(String var1);

    public boolean isExcludedNode(Node var1) throws RepositoryException;

    public boolean isReservedProperty(String var1);

    public static interface RolloutProgress {
        public void reportProgress(String var1, String var2);
    }

    public static class RolloutParams {
        public Page main;
        public Page master;
        public Resource source;
        public boolean isDeep;
        public Trigger trigger;
        public String[] targets;
        public String[] paragraphs;
        public String[] fields;
        public boolean reset;
        @Deprecated
        public boolean delete;
        public RolloutProgress rolloutProgress;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            if (this.main != null) {
                sb.append(", Main path=");
                sb.append(this.main.getPath());
            } else if (this.master != null) {
                sb.append(", Main path=");
                sb.append(this.master.getPath());
            } else {
                sb.append(", Source path=");
                sb.append(this.source.getPath());
            }
            if (this.trigger != null) {
                sb.append(", Trigger=");
                sb.append((Object)this.trigger);
            }
            if (this.targets != null) {
                sb.append(", Targets=");
                sb.append(Arrays.asList(this.targets));
            }
            if (this.paragraphs != null) {
                sb.append(", Paragraphs=");
                sb.append(Arrays.asList(this.paragraphs));
            }
            sb.append(this.isDeep ? " isDeep" : "");
            sb.append(this.reset ? " reset" : "");
            return sb.toString();
        }
    }

    public static enum Trigger {
        NEVER("never"),
        MODIFICATION("modification"),
        PUBLICATION("publish"),
        DEACTIVATION("deactivate"),
        ROLLOUT("rollout");

        private final String name;

        private Trigger(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Trigger fromName(String name) {
            for (Trigger m : Trigger.values()) {
                if (!m.toString().equals(name) && !m.name().equals(name)) continue;
                return m;
            }
            throw new IllegalArgumentException("Unknown trigger type: " + name);
        }
    }
}

